# coding: utf-8
import json
from django import forms
from django.http import HttpResponse
from django.views.decorators.http import require_POST
from django_api_auth.decorators import passport_or_token_auth

from mlcore.ml.forms import CreateRequestForm
from mlcore.ml.models import MailList
from mlcore.subscribe import subscription_type
from .base import MailListFormMixin, JSONField


class SubscribeForm(MailListFormMixin, forms.Form):
    subscribers = JSONField()

    def clean_subscribers(self):
        recipients = self.cleaned_data['subscribers']
        types = (subscription_type.IMAP, subscription_type.INBOX, subscription_type.BOTH)

        cleaned_subscribers = []
        for type_ in types:
            uids = recipients.get(type_)
            if uids:
                cleaned_subscribers.append((type_, uids))

        return cleaned_subscribers


class CreateRequestApiForm(CreateRequestForm, forms.Form):
    def clean_responsible(self):
        data = self.cleaned_data['responsible']

        return data


@require_POST
@passport_or_token_auth
def invalidate_cache(request):
    uid = request.POST.get('uid')

    found = False
    for maillist in MailList.objects.filter(backends__yandexteambackendcontext__uid=uid):
        found = True
        maillist.set_as_modified()

    if not found:
        return HttpResponse(json.dumps({'status': 'error'}), status=404, content_type='application/json')

    return HttpResponse(json.dumps({'status': 'ok'}), content_type='application/json')


@require_POST
@passport_or_token_auth
def set_fid(request):
    uid = request.POST.get('uid')
    fid = request.POST.get('fid')

    found = False
    for maillist in MailList.objects.filter(backends__yandexteambackendcontext__uid=uid):
        maillist.fid = fid
        maillist.save()
        found = True

    if not found:
        return HttpResponse(json.dumps({'status': 'error'}), status=404, content_type='application/json')

    return HttpResponse(json.dumps({'status': 'ok'}), content_type='application/json')
