# coding: utf-8
import json
from django.http import HttpResponse
from .helpers import maillist_by_email


def split_tokens(s, delim=','):
    if not s:
        raise StopIteration
    for t in s.split(delim):
        yield t.strip()


def lists_exists(request):
    """
    ML-1477: Существует ли список рассылки с таким email

    Ручка принимает список email-ов через запятую в GET-параметре emails.
    Возвращает json со списком адресов, которые являются рассылками.

    $ curl "<host>/apiv2/maillist/exists?emails=bbS@yandex-team.ru,a@b.c"
    {"maillists": ["bbS@yandex-team.ru"]}
    """
    lists = set()
    for email in split_tokens(request.GET.get('emails'), ','):
        if maillist_by_email(email):
            lists.add(email)

    return HttpResponse(json.dumps({'maillists': sorted(lists)}),
                        content_type='application/json')
