# coding: utf-8
import json
from django.http import HttpResponse, HttpResponseBadRequest
from django.views.decorators.http import require_GET
from mlcore.ml.models import MailList
from mlcore.permissions.utils import get_permitted_staff
from mlcore.utils.getters import get_suid, get_list_suid, get_list


@require_GET
def readonly_maillists(request):
    res = {}
    for maillist in MailList.objects.filter(readonly=True).exclude(email=''):
        emails = set(get_permitted_staff(maillist, 'write')
                     .filter(is_dismissed=False).values_list('login', flat=True))

        res[maillist.email] = list(emails)

    return HttpResponse(json.dumps(res), content_type='application/json')
