# coding: utf-8
import json
import logging
from django.http import HttpResponse
from django.views.decorators.http import require_GET
import datetime
from django_intranet_stuff.models import LastUpdate


def _has_errors(l, max_variation):
    now = datetime.datetime.now()
    hours_variation = datetime.timedelta(hours=max_variation)
    if (now - l.updated_at) > hours_variation:
        return True
    return False


@require_GET
def intranet_lastupdate_info(request):
    """
    Проверяет статус обновления данных django_intranet_staff

    GET /apiv2/intranet/lastupdate
    type,updated_at,status
    updatecenter,2014-06-18T17:30:43,OK
    sync_django_users,2014-06-17T18:09:07,ERROR
    ml_center_log_parse,2014-06-17T18:20:02,ERROR
    membership_log,2014-06-17T18:20:02,ERROR
    """

    resp = ["type, updated_at, status"]

    has_errors = False
    for l in LastUpdate.objects.filter():
        if l.type == 'membership_log' or l.type == 'ml_center_log_parse':
            has_errors = _has_errors(l, 24)
        elif l.type == 'sync_django_users' or l.type == 'updatecenter':
            has_errors = _has_errors(l, 24)

        status = "ERROR" if has_errors else "OK"
        resp.append("%s, %s, %s" % (l.type, l.updated_at.isoformat(), status))

    return HttpResponse("\n".join(resp),
                        mimetype="text/plain",
                        status=206 if has_errors else 200)

