# coding: utf-8
import json
from django.http import HttpResponse
from mlcore.permissions.utils import get_permitted_staff
from mlcore.nwsmtp_connect.utils import get_passport_aliases
from django_api_auth.decorators import passport_or_token_auth
from .helpers import maillist_by_email


def _list_subscribers(maillist, cache=None, via=None, expand=True):

    if cache is None:
        cache = set()

    if maillist.id in cache:
        raise StopIteration

    cache.add(maillist.id)

    for username, email, is_imap, is_sub in maillist.subscribers_set\
            .filter(user__is_active=True)\
            .values_list('user__username', 'user__email', 'is_imap', 'is_sub'):
        data = {'login': username, 'inbox': is_sub, 'imap': is_imap, 'email': email}
        if via:
            data['via'] = via[:]
        yield data

    for email in maillist.emailsubscriber_set.values_list('email', flat=True):
        ml = maillist_by_email(email)
        if ml and expand:
            if via is None:
                via = []
            # Случай "рассылка-подписана-на-рассылку"
            via.append(email)
            for _ in _list_subscribers(ml, cache=cache, via=via, expand=expand):
                yield _
        else:
            data = {'email': email, 'login': None, 'inbox': True, 'imap': False}
            if via:
                data['via'] = via[:]
            yield data


@passport_or_token_auth
def mass_lists_subscribers(request):
    """
    ML-1396: Ручка экспорта подписчиков рассылки для Календаря
    """
    emails = request.GET.get('emails')
    expand = request.GET.get('expand', 'no') == 'yes'
    if emails:
        r = {}
        emails = emails.split(',')
        for email in emails:
            maillist = maillist_by_email(email)
            if maillist:
                data = {'subscribers': list(_list_subscribers(maillist, expand=expand)),
                        'is_internal': maillist.is_internal,
                        'is_open': maillist.is_open,
                        }
                if maillist.readonly:
                    data.update({'readonly': True,
                                 'who_can_write': get_passport_aliases(
                                     set(get_permitted_staff(maillist, 'write')
                                        .filter(is_dismissed=False).values_list('work_email', flat=True))),})

                r[email] = data
            else:
                r[email] = None
        return HttpResponse(json.dumps({'result': r}), content_type='application/json')
    else:
        return HttpResponse("emails parameter required", status=400)