# coding: utf-8
import json
from django import forms
from django.http import HttpResponse, HttpResponseBadRequest
from django.views.decorators.http import require_GET
from mlcore.ml.models import SuidLookup, Subscribers


class UserRightsForm(forms.Form):
    user_suid = forms.IntegerField()


@require_GET
def user_subscriptions(request):
    f = UserRightsForm(request.GET)
    if f.is_valid():
        try:
            login = SuidLookup.objects.get(suid=f.cleaned_data['user_suid']).login
        except SuidLookup.DoesNotExist:
            return HttpResponseBadRequest("Cant't find user")

        subs = Subscribers.objects.filter(
            user__username=login).select_related('list').values_list(
                'list__fsuid', 'list__name', 'stype')
        res = [dict(zip(('suid', 'name', 'type'), i)) for i in subs]
        return HttpResponse(json.dumps(res), content_type='application/json')
    else:
        return HttpResponseBadRequest(f.errors.as_text(),
                                      content_type='text/plain; charset=UTF-8')
