# coding: utf-8
import json
import logging
from django_api_auth.decorators import passport_or_token_auth
from django.http import HttpResponse, HttpResponseBadRequest
from django.views.decorators.http import require_GET, require_POST
from mlcore.ml.models import CorporateDomain
from mlcore.ml.forms import DomainsForm


@require_GET
def get_domains(request):
    """
    Получить список всех доменов (из ML)
    """
    res = [d.domain for d in CorporateDomain.objects.all()]
    return HttpResponse(json.dumps(res), content_type='application/json')


@require_POST
@passport_or_token_auth
def add_domains(request):
    """
    Добавляем домены в базу ML
    """
    form = DomainsForm(request.POST)

    message = ''

    if form.is_valid():
        try:
            for domain in form.cleaned_data['domains']:
                d = CorporateDomain(domain=domain)
                d.save()
            return HttpResponse(json.dumps({'status': 'ok'}),
                                content_type='application/json')
        except Exception as exc:
            message = "%s" % exc

    if form.errors:
        message = form.errors.as_text()

    errors = {'status': 'error', 'message': message}
    return HttpResponseBadRequest(json.dumps(errors),
                                  content_type='application/json')