# coding: utf-8

from django.conf.urls import patterns, url

from mlcore.apiv3.views.lists import ListReadableMailListsForStaffView
from mlcore.apiv3.views.misc import CreateUserInOrganizationView

urlpatterns = patterns(
    'mlcore.apiv3.views',
    url(r'^lists/info$', 'lists_info', name='lists_info'),
    url(r'^lists/default$', 'get_default_lists', name='lists_default'),
    url(r'^lists/create$', 'create', name='lists_create'),
    url(r'^lists/subscribe$', 'subscribe', name='lists_subscribe'),
    url(r'^lists/unsubscribe$', 'subscribe', name='lists_unsubscribe'),
    url(r'^lists/get$', 'lists_get', name='lists_get'),
    url(r'^lists/subscribers$', 'lists_subscribers', name='lists_subscribers'),
    url(r'^lists/corp_user$', 'get_corp_user', name='lists_corp_user'),
    url(r'^lists/staff_maillists', ListReadableMailListsForStaffView.as_view(), name='list_staff_maillists'),
    url(r'^lists/user_in_domain', CreateUserInOrganizationView.as_view(), name='list_staff_maillists')
)
