# encoding: utf-8
from __future__ import unicode_literals

import logging

from functools import wraps
from django.http import HttpResponseForbidden
from django.conf import settings

from mlcore.utils.tvm2 import TVM2_CONFIG

_tvm_2_ticket_checker = TVM2_CONFIG.ticket_checker()


def check_tvm_2_ticket(request, allowed_clients=None):
    ticket = str(request.META.get('HTTP_X_YA_SERVICE_TICKET', ''))
    check_result = _tvm_2_ticket_checker.check_tickets(tvm_2_service_ticket=ticket)
    return check_result.valid and any(check_result.has_src(src) for src in allowed_clients)


def tvm_required(func=None, allowed_clients=None):
    """Декоратор для view, проверяющий твм 2 тикеты"""
    if allowed_clients is not None:
        clients = tuple(allowed_clients)
    else:
        clients = tuple(settings.TVM2_CLIENTS)

    def decorate(f):
        @wraps(f)
        def wrapper(request, *args, **kwargs):
            if not check_tvm_2_ticket(request, allowed_clients=clients):
                return HttpResponseForbidden('Forbidden: tvm required', mimetype='text/plain')
            return f(request, *args, **kwargs)
        return wrapper

    if func:
        return decorate(func)

    return decorate
