# encoding: utf-8

# Модуль для перехода на новый requests
# Когда полностью перейдём на requests>1.1, этот модуль можно отпилить

import requests

IS_YOUNG_REQUESTS = (requests.__version__ < '1.0.4')

def compat_requests_session(timeout=None, cert=None, **kwargs):
    if IS_YOUNG_REQUESTS:
        # Тулзы использовали версию 0.13.6yandex1
        # Код сессии был примерно такой: https://github.com/kennethreitz/requests/blob/v0.13.6/requests/sessions.py
        return requests.session(cert=cert, timeout=timeout, **kwargs)
    else:
        # В requests 2.0+ код сессии другой:
        # https://github.com/kennethreitz/requests/blob/v2.0.0/requests/sessions.py 
        s = requests.Session()
        s.timeout = timeout
        s.cert = cert
        s.params = kwargs
        return s


def compat_requests_json(resp):
    # Раньше json был свойством:
    # https://github.com/kennethreitz/requests/blob/v0.13.6/requests/models.py#L813
    r = resp.json
    if hasattr(r, '__call__'):
        # А потом json стал функцией
        # https://github.com/kennethreitz/requests/blob/v2.0.0/requests/models.py#L676
        r = r()
    return r
