# encoding: utf-8
from __future__ import unicode_literals
from .compat import compat_requests_session, compat_requests_json
from django.conf import settings

from base import BaseMailInteractionBackend, wrap_session
from mlcore.utils.getters import get_suid


class MopsError(Exception):
    def __init__(self, message, code=None):
        self.message = message
        self.code = code
        super(MopsError, self).__init__(message, code)


class MopsBackend(BaseMailInteractionBackend):

    backend_type = 'mops'

    def __init__(self, url=settings.MOPS_API_URL, mdb=settings.YWMI_API_MDB, timeout=20,
                 dry_run=False, logger=None, destination_id=settings.MOPS_TVM_ID, **kwargs):
        super(MopsBackend, self).__init__()

        if logger:
            self.log = logger

        session = compat_requests_session(timeout=timeout, **kwargs)
        self.http = wrap_session(session, dry_run=dry_run, logger=logger, destination_id=destination_id)
        self.url = url
        self.mdb = mdb
        self.dry_run = dry_run

    def __check_and_parse(self, response):
        try:
            self.error_test(response)
        except IOError:
            if response.status_code == 400:
                raise MopsError("Bad request. %s" % response.url)
            else:
                raise
        json = compat_requests_json(response)
        return json

    def __make_request(self, method, data):
        resp = self.http.post('{0}/{1}'.format(self.url, method), data=data)

        if self.dry_run:
            return {}

        return self.__check_and_parse(resp)

    def create_folder(self, name, user):
        data = {
            'uid': user.staff.uid,
            'suid': get_suid(user),
            'name': name,
            'mdb': self.mdb,
        }

        resp = self.__make_request('folders/create', data)
        return resp.get('fid')
