# coding: utf-8

from lxml import etree


def valid_XML_char_ordinal(i):
    return (
        0x20 <= i <= 0xD7FF
        or i in (0x9, 0xA, 0xD)
        or 0xE000 <= i <= 0xFFFD
        or 0x10000 <= i <= 0x10FFFF
        )


def clean_string(string):
    return ''.join(c for c in string if valid_XML_char_ordinal(ord(c)))


def dict2xml(data, root_name='root', **kwargs):
    root = etree.Element(root_name, kwargs)
    _serialise_subelement(data, root)
    return root


def dict2xmlstring(data, root_name='root', **kwargs):
    root = dict2xml(data, root_name, **kwargs)
    return etree.tostring(root, encoding='unicode')


def _serialise_subelement(data, root):
    if isinstance(data, dict):
        for key, value in data.iteritems():
            elem = etree.SubElement(root, key)

            _serialise_subelement(value, elem)
    elif isinstance(data, (list, tuple)):
        for item in data:
            elem = etree.SubElement(root, 'item')

            _serialise_subelement(item, elem)
    elif data:
        root.text = clean_string(unicode(data))
