# -*- coding: utf-8 -*-
from django.utils.encoding import smart_str
from django.conf import settings

from sanitize import sanitizeHTML

def clean_html(html, base_url=None):

    if base_url is None:
        base_url = settings.EMAIL_BASE_URL

    return sanitizeHTML(smart_str(html), base_url, 0)
