# encoding: utf-8

import re
from django_intranet_stuff.utils.translate import translate

TRANSLATE_SERVICE_ID = 'yamail'

# В телах писем надо экранировать теги, иначе перевод становится несколько странным
ESCAPE_PATTERNS = [re.compile('<[^>]*>', re.U | re.M)]


def translate_thread_list(thread_list, language_from, language_to):

    translation_path = '-'.join([language_from, language_to])

    for thread in thread_list:
        thread.subject = translate(thread.subject, translation_path, srv=TRANSLATE_SERVICE_ID)
    return thread_list


def translate_thread(thread, language_from, language_to):

    translation_path = '-'.join([language_from, language_to])

    for message in thread.messages:
        message.is_translated = True
        message.original_firstline = message.firstline
        message.firstline = translate(
            message.original_firstline, translation_path, srv=TRANSLATE_SERVICE_ID)
        message.original_hdr_subject = message.subject
        message.subject = translate(
            message.subject, translation_path, srv=TRANSLATE_SERVICE_ID)
        message.language_from = language_from
        message.language_to = language_to

    thread.is_translated = True
    thread.translated_thread_subject = translate(
        thread.thread_subject, translation_path, srv=TRANSLATE_SERVICE_ID)
    return thread


def translate_message(message, language_from, language_to):
    translation_path = '-'.join([language_from, language_to])

    first_part = message.get_parts()[0]
    message.is_translated = True
    message.translated_content = translate(
        first_part.content, translation_path, srv=TRANSLATE_SERVICE_ID, escape_patterns=ESCAPE_PATTERNS)

    return message
