# -*- coding: utf-8 -*-

from django.conf.urls import patterns, url

import views
import class_views

thread_node = class_views.ThreadNode()
thread_list = class_views.ThreadList()

urlpatterns = patterns(
    '',
    url(r'^list/(?P<name>[^\s\\/]+)/$', thread_list, name='thread_list'),
    url(r'^list/(?P<name>[^\s\\/]+)/\.(?P<language_from>\w+)\-(?P<language_to>\w+)$',
        thread_list, name='translated_thread_list'),
    url(r'^list/(?P<name>[^\s\\/]+)/remove/(?P<mid>\d+)/$', views.message_remove, name='message_remove'),

    url(r'^thread/(?P<name>[^\s\\/]+)/(?P<thread_id>\d+)/$',
        thread_node, name='thread'),
    url(r'^thread/(?P<name>[^\s\\/]+)/(?P<thread_id>\d+)/\.(?P<language_from>\w+)\-(?P<language_to>\w+)$',
        thread_node, name='translated_thread'),

    url(r'^thread/(?P<thread_id>\d+)/$',
        views.thread_redirect, name='deprecated_thread_url'),

    url(r'^message/(?P<name>[^\s\\/]+)/(?P<mid>\d+)/body/$', views.message_body, name='message_body'),
    url(r'^message/(?P<name>[^\s\\/]+)/(?P<mid>\d+)/body/\.(?P<language_from>\w+)\-(?P<language_to>\w+)$',
        views.message_body, name='translated_message_body'),
    url(r'^message/(?P<name>[^\s\\/]+)/(?P<mid>\d+)/attachment/(?P<hid>[\d.]+)/$',
        views.message_attachment, name='attachment'),

    url(r'^thread(\d+)/complain/msg(\d+)/$', views.complain, name='complain'),  # Dead link
    url(r'^thread(\d+)/complain/msg(\d+)\.json/$', views.complain_json, name='complain_json'),  # Dead link
)
