# -*- coding: utf-8 -*-
import re
from django.utils.html import escape

GRABLINE_REGEXP = re.compile(r'^([> ]+)(.*)$', re.S)
BLOCKQUOTE_LINE_TPL = '<div class="line-%(cls)s level-%(level)d">%(content)s</div>'
BLOCKQUOTE_TPL = '<blockquote class="bq-%(style)d level-%(level)d">%(content)s</blockquote>'
CONTROL_LINE_TPL = '<span class="control">&nbsp;</span>%s'

def _format(struct, level=0):
    out = []
    for item in struct:
        if type(item) != list:
            out.append('>' * level + item)
        else:
            out.append(_format(item, level+1))
    return '\n'.join(out)

def blockquote_text(letter, line_tpl=BLOCKQUOTE_LINE_TPL, block_tpl=BLOCKQUOTE_TPL):
    return quoteoutput(text2struct(letter)[0])

def quoteoutput(letter, level=0, mod=2, line_tpl=BLOCKQUOTE_LINE_TPL, block_tpl=BLOCKQUOTE_TPL, control_out=False):
    letter = trim_struct(letter)

    show_control = not control_out
    if show_control and len(letter) == 1 and type(letter[0]) != list:
        show_control = False

    # main picker recursive cycle
    out = []
    something_typed = False

    for item in letter:
        bqstyle = level % mod

        if type(item) != list:
            if item.strip():
                if show_control and level > 0:
                    out.append((CONTROL_LINE_TPL % item) + "<br/>")
                    show_control = False
                    control_out = True
                    something_typed = True
                else:
                    out.append(escape(item) + "<br/>")
                    something_typed = True
            elif something_typed:
                out.append("<br/>")

        else:
            if level == 0:
                out.append('<div class="content content-closed level-' + str(level) + '">')
            (text, control_out) = quoteoutput(item, level+1, mod, line_tpl, block_tpl, control_out)
            if control_out:
                show_control = False
            out.append(block_tpl % dict(style=bqstyle, level=level, content=text))
            if level == 0:
                out.append('</div>')
            something_typed = True

        if level == 0:
            control_out = False

    if level == 0:
        return '\n'.join(out)

    return ('\n'.join(out), control_out)

def text2struct(text, regexp=GRABLINE_REGEXP):
    def grabline(lines, regexp=GRABLINE_REGEXP, idx=0, curlevel=0):
        bank     = []
        listlen  = 0

        while 1:
            try:
                match = regexp.match(lines[idx])
            except IndexError:
                return (bank, listlen)

            if match:
                (deep, rest) = match.group(1, 2)
                deep = deep.count('>')
            else:
                if not lines[idx].strip():
                    deep = curlevel
                    rest = lines[idx]
                else:
                    deep = 0
                    rest = lines[idx]

            rest = rest.rstrip()

            if not lines[idx].strip():
                pass

            if deep == curlevel:
                bank.append(rest)
                idx     += 1
                listlen += 1

            elif deep > curlevel:
                (down, downlen) = grabline(lines, regexp, idx, curlevel + 1)
                bank.append(down)
                idx     += downlen
                listlen += downlen

            elif deep < curlevel:
                return (bank, listlen)

    return grabline(('\n' + text).split('\n'), regexp)


def trim_struct(letter, n=3, replby=1):
    from itertools import groupby, chain, starmap
    return list(
        chain(*(
            [[''], grp][item or len(grp)<n]
                for item, grp in ((bool(item), list(grp))
                    for item, grp in groupby(chain(['']*n, letter, ['']*n), lambda x:x))
        ))
    )[replby:-replby]
