# -*- coding: utf-8 -*-
from django.conf import settings
from django.http import HttpResponse, HttpResponseRedirect
from django.core.mail import EmailMessage
from django.core.urlresolvers import reverse
from django.contrib.auth.decorators import login_required


__all__ = ['complain', 'complain_json']


@login_required
def complain(request, first_message_id, message_id):
    complain_logic(request, message_id)
    return HttpResponseRedirect(reverse('mailarchive:thread', args=[first_message_id]))


@login_required
def complain_json(request, first_message_id, message_id):

    from json import JSONEncoder

    try:
        complain_logic(request, message_id)
    except:
        data = dict(
            success=False,
            _errors='Error occured while sending message',
        )
    else:
        data = dict(
            success=True,
            message='Message sent. Thank you!',
        )

    json = JSONEncoder()
    return HttpResponse(json.encode(data), mimetype='application/json')


def complain_logic(request, message_id):

    # check if message_id is in db
    #get_object_or_404(Message, pk=message_id)

    try:
        comment = request.POST['message']
    except KeyError:
        comment = ''

    try:
        email = request.user.email
    except:
        login = request.META.get('REMOTE_ADDR', None)
        email = 'no-reply@yandex-team.ru'

    # TODO: get email of logged in user
    message = prepare_email_message(request, (login, email), message_id, comment)
    message.send()


def prepare_email_message(request, sender, message_id, comment):

    from_name, from_email = sender
    if from_name:
        from_email = '%s <%s>' % (from_name, from_email)
    to = settings.COMPLAIN_EMAIL

    message_link = request.build_absolute_uri(reverse('thread', args=[message_id]) + '#message%s' % message_id)
    message = EmailMessage(subject='Bad email message %s in archive' % message_id,
        body='From: %s' % from_name + '\nBad message %s' % message_link + '\n Comment was: %s' % comment,
        from_email=from_email, to=[to])
    return message
