# -*- coding: utf-8 -*-
import os

from django.conf import settings
from django.http import HttpResponseRedirect, Http404
from django.core.urlresolvers import reverse
from django.contrib.auth.decorators import login_required


LEGACY_THREAD_DB_FILE = getattr(settings, 'LEGACY_THREAD_DB_FILE', None)

if LEGACY_THREAD_DB_FILE and os.path.isfile(LEGACY_THREAD_DB_FILE):
    import bsddb
    legacy_thread_lookup = bsddb.rnopen(LEGACY_THREAD_DB_FILE)
else:
    legacy_thread_lookup = {}


@login_required
def legacy_thread(request, thread_id, message_id=None):
    if message_id is None:
        message_id = thread_id

    hdr_message_id = legacy_thread_lookup.get(int(message_id))
    if not hdr_message_id:
        raise Http404

    return HttpResponseRedirect(reverse('mailarchive:message_by_id', args=(hdr_message_id,)))
