# -*- coding: utf-8 -*-

from django.contrib.auth.decorators import login_required
from django.http import Http404
from django.shortcuts import redirect
from django.core.urlresolvers import reverse

from mlcore.interaction.ywmi import YWMIBackend, YWMIError

from mlcore.utils.getters import get_list, get_list_by_uid


@login_required
def thread_redirect(request, thread_id, **kwargs):
    """
    Редирект для ссылок старого формата, не использующих список рассылки для отображения тредов
    """
    try:
        uid = YWMIBackend().get_uid_from_mapping(thread_id)
    except YWMIError:
        raise Http404

    maillist = get_list_by_uid(uid)
    if not maillist:
        raise Http404

    return redirect(reverse('mailarchive:thread', kwargs=dict(name=maillist.name, thread_id=thread_id)))
