# -*- coding: utf-8 -*-
from django.contrib import messages

class BaseMessager(object):
    """
    Base Class for Messager – `logger` for user messages.
    """

    def debug(self, message):
        self._say('debug', message)

    def info(self, message):
        self._say('info', message)

    def success(self, message):
        self._say('success', message)

    def warning(self, message):
        self._say('warning', message)

    def error(self, message):
        self._say('error', message)

    def _say(self, level, message):
        raise NotImplementedError


class Messager(BaseMessager):
    """
    Messager, which sends messages to the user via django messages framework.
    """

    def __init__(self, request):
        super(BaseMessager, self).__init__()
        self.request = request

    def _say(self, level, message):
        if hasattr(messages, level):
            getattr(messages, level)(self.request, message)


class AjaxMessager(BaseMessager):
    """
    Messager, which store messages in itself.
    """

    def __init__(self):
        super(AjaxMessager, self).__init__()
        self._messages = []

    def _say(self, level, message):
        if hasattr(messages, level):
            self._messages.append((level, message))

    def get_messages(self):
        while True:
            try:
                yield self._messages.pop()
            except IndexError:
                raise StopIteration
