# -*- coding: utf-8 -*-
import logging

from django.template import RequestContext
from django.http import HttpResponse, HttpResponseForbidden
from django.shortcuts import render_to_response, redirect, get_object_or_404
from django.utils.decorators import method_decorator
from django.contrib.auth.decorators import login_required
from django import forms

from mlcore.ml.class_views.base import BaseView
from mlcore.interaction.ymail import YmailBackend, YmailError


import yenv
dry_run = (yenv.type == 'development')

logger = logging.getLogger(__name__)




class MlApiRequestForm(forms.Form):
    request = forms.CharField(
        widget=forms.Textarea(
            attrs={'rows': 5, 'cols': 100,
                   'placeholder': u'Example: SharedFolderInfo?folder_uname=1120000000044833'}),
        label=u"Параметры для ручки YmailApi", required=False)
    response = forms.CharField(
        widget=forms.Textarea(
            attrs={'rows': 7, 'cols': 100,
                   'placeholder': u'Ответ в виде json',
                    'readonly': "readonly",
            }),
        label=u"Ответ: ", required=False,
    )


@login_required
def mlapi_admin_view(request):

    if not request.user.is_superuser:
        return HttpResponseForbidden("Access forbidden")

    context = {
        'user': request.user,
        'form': MlApiRequestForm(),
        'response': None,
        'exception': None
    }

    if request.method == 'POST':

        form = MlApiRequestForm(request.POST)

        if form.is_valid():
            ymail = YmailBackend()
            method = form.cleaned_data['request'].strip()
            url = ymail.url + method
            context['url'] = url
            try:
                resp = ymail.http.get(url)
            except Exception as exc:
                context['exception'] = str(exc)
                logger.exception('Ошибка при обращении к mlapi')

            context['response'] = resp

            if resp.status_code == 200:
                import json
                context['formatted_response'] = json.dumps( json.loads(resp.content), indent=1, ensure_ascii=False)
            else:
                context['formatted_response'] = resp.content

            context['formatted_headers'] = "\n".join(["%s: %s" % (k,v) for (k,v) in resp.headers.items()])
            context['form'] = MlApiRequestForm(initial={'request': method})

    return render_to_response('admin/ml/mlapi_call.html',
                              context, RequestContext(request))

