# -*- coding: utf-8 -*-

#import logging

from django.shortcuts import render_to_response, get_object_or_404
from django.utils.decorators import method_decorator
from django.contrib.auth.decorators import login_required
from django.template import RequestContext
from django.contrib.auth.models import User
from django.db.models import Q

from mlcore.stats.user_activity import get_activity_log

from mlcore.ml.class_views.base import BaseView
from mlcore.ml.models import Subscribers
from mlcore.permissions.center_group_synchro import\
    get_maillists_to_unsubscribe


class StaffNode(BaseView):

    def can_read_activity_log(self):
        return self.user == self.selected_user or self.user.is_staff

    @method_decorator(login_required)
    def __call__(self, request, username):

        self.user = request.user
        if self.user.username == username:
            self.selected_user = selected_user = self.user
            self_page = True
        else:
            self_page = False
            self.selected_user = selected_user = get_object_or_404(User, username=username)


        # if action_activity_log in request, render activity log table only
        # (for ajax response)
        if 'action_activity_log' in request.REQUEST and self.can_read_activity_log():
            return render_to_response('mailarchive/staff_activity_log.html',
                    {'activity_log': get_activity_log(selected_user, limit=None)})

        # do not evaluate activity log if it is not to be shown
        activity_log = [] if not self.can_read_activity_log()\
                       else get_activity_log(selected_user, limit=10)

        subscribes = selected_user.subscriptions.select_related('list').order_by('list__name').all()
        user_subscribes = [] if self_page\
                          else self.user.subscriptions.values_list('list__name', flat=True)

        if not self_page:
            subscribes = subscribes.exclude(
                    Q(list__is_hidden=True) & ~Q(list__name__in=user_subscribes))

        supported = [o.list for o in selected_user.owner_set.filter(list__is_deleted=False)]

        type_display_map = Subscribers.TYPE_DISPLAY_MAP[:-1]

        if self.user == self.selected_user or self.user.is_staff:
            lists_to_unsubscribe = get_maillists_to_unsubscribe(self.selected_user)
        else:
            lists_to_unsubscribe = ()

        return render_to_response('mailarchive/staff.html',
                RequestContext(request, {
                    'self_page': self_page,
                    'selected_user': selected_user,
                    'user': request.user,
                    'subscribes': subscribes,
                    'user_subscribes': user_subscribes,
                    'letters': self._get_letters(),
                    'supported': supported,
                    'activity_log': activity_log,
                    'type_choices': type_display_map,
                    'restricted_lists': lists_to_unsubscribe,
                }))
