# encoding: utf-8
from functools import wraps

from django.core.management.base import BaseCommand
from django.contrib.auth.models import User
from mlcore.permissions.utils import group_permitted_usernames
from mlcore.permissions.models import ListPermission
from mlcore.ml.models import Autosubscription, Subscribers
from mlcore.tasks import operations


try:
    from django_intranet_stuff.commands import log_command_failure
except ImportError:
    def log_command_failure(logger):
        if isinstance(logger, str):
            logger = logging.getLogger(logger)
        def _func(func):
            @wraps(func)
            def wrapper(*args, **kwargs):
                try:
                    return func(*args, **kwargs)
                except Exception, e:
                    logger.exception(e)
            return wrapper
        return _func


import logging
logger = logging.getLogger(__name__)


class Command(BaseCommand):
    help = u"Автоподписка"

    @log_command_failure(logger)
    def handle(self, *args, **options):

        for autosub in Autosubscription.objects.all():
            maillist = autosub.maillist
            members = autosub.group.get_all_members()\
                                   .values_list('login', flat=True)

            to_subscribe = User.objects.filter(username__in=members,
                                               is_active=True)\
                                       .exclude(subscriptions__list=maillist)\
                                       .exclude(email='')

            if not maillist.is_open:
                has_permissions = set(group_permitted_usernames(maillist)
                                      .values_list('login', flat=True))
                has_permissions.update(
                    ListPermission.objects.filter(list=maillist, approved=True)
                    .values_list('user__username', flat=True))

                to_subscribe = to_subscribe.filter(username__in=has_permissions)

            self._subscribe(maillist, to_subscribe, autosub)

            to_unsubscribe = User.objects.filter(
                pk__in=Subscribers.objects.filter(
                    list=maillist, autosubscription=autosub)
                .exclude(user__username__in=members)
                .values_list('user', flat=True))

            self._unsubscribe(maillist, to_unsubscribe, autosub)

    def _subscribe(self, maillist, to_subscribe, autosubscription):
        for u in to_subscribe:
            if not u.email:
                continue

            operations.subscribe_user.delay(
                {
                    'initiator': 'autosubscription',
                    'comment': u'Автоподписка новых людей'
                },
                u,
                maillist,
                autosubscription.stype,
                check_rights=False,
                autosubscription=autosubscription
            )

    def _unsubscribe(self, maillist, to_unsubscribe, autosubscription):
        for u in to_unsubscribe:
            operations.unsubscribe.delay(
                {
                    'initiator': 'autosubscription',
                    'comment': u'Автоотписка'
                },
                u,
                maillist,
                autosubscription=autosubscription
            )
