# -*- coding: utf-8 -*-
from django.core.management.base import BaseCommand

from mlcore.ml.models import Subscribers
from mlcore.tasks import operations


class Command(BaseCommand):
    help = "Unsubscribe all dismissed staff from ml"

    def handle(self, *args, **options):

        for sub in Subscribers.objects.select_related().filter(
                user__staff__is_dismissed=True):

            operations.unsubscribe.delay(
                {
                    'initiator': 'autounsubscribe-dissmised',
                    'comment': u'Автоотписка уволенных'
                },
                sub.user,
                sub.list
            )
