# -*- coding: utf-8 -*-
import MySQLdb
from datetime import timedelta, datetime
from django.core.management.base import BaseCommand
from maillists.mlcore.ml.models import OperationLog
from maillists import settings



LOGS_DAYS_TTL = 30


class Command(BaseCommand):
    help = "Cleanup ml_operationlog table"


    def get_mysql(self):
        DATABASES = settings.DATABASES
        master = DATABASES["default"]["HOST"]
        user = DATABASES["default"]["USER"]
        password = DATABASES["default"]["PASSWORD"]
        dbname = DATABASES["default"]["NAME"]
        db = MySQLdb.connect(host=master, user=user, passwd=password,
                             db=dbname, charset="utf8", connect_timeout=10)
        return db, db.cursor()


    def delete_task_ids(self, task_ids):
        task_ids = ",".join(task_ids)
        sql = "DELETE FROM ml_operationlog WHERE task_id in (" + task_ids + ");"

        db, cursor = self.get_mysql()
        cursor.execute(sql)
        db.commit()
        cursor.close()
        db.close()



    def handle(self, *args, **options):
        logs_doom_day = datetime.now() - timedelta(days=LOGS_DAYS_TTL)

        task_ids = []
        for log in OperationLog.objects.filter(started__lte=logs_doom_day):
            task_ids.append('"' + log.task_id + '"')
        if len(task_ids):
            self.delete_task_ids(task_ids)
