# -*- coding: utf-8 -*-
import logging
from optparse import make_option
from django.core.management.base import BaseCommand
from mlcore.utils.getters import get_list
from mlcore.tasks.operations import subscribe_user, subscribe_email
import time


log = logging.getLogger(__name__)


def copy_subscribers(from_list, to_list):
    from_list = get_list(from_list)
    to_list = get_list(to_list)

    for src_email_subscriber in from_list.emailsubscriber_set.filter():
        dst_email_subscribers = to_list.emailsubscriber_set.filter(email=src_email_subscriber.email)
        if not dst_email_subscribers:
            context = {
                'initiator': 'admin',
                'comment': u'Копирование подписчиков из %s -> %s' % (from_list, to_list),
            }
            yield subscribe_email.si(context, email=src_email_subscriber.email, maillist=to_list)

    for src_subscriber in from_list.subscribers_set.filter():
        dst_subscribers = to_list.subscribers_set.filter(user=src_subscriber.user, list=to_list)
        if not dst_subscribers:
            context = {
                'initiator': 'admin',
                'comment': u'Копирование подписчиков из %s -> %s' % (from_list, to_list),
            }
            yield subscribe_user.si(context, user=src_subscriber.user,
                                    maillist=to_list, type=src_subscriber.stype,
                                    check_rights=False, send_notification=False)


class Command(BaseCommand):
    help = "Copy subscribers from old list to new list"
    option_list = BaseCommand.option_list + (
        make_option('-d', '--dry-run', action='store_true', dest='dry_run',
                    default=False, help="Dry run"),
    )

    def handle(self, *args, **options):
        dry_run = options.get('dry_run', False)
        from_list = args[0]
        to_list = args[1]
        print "Copy subscribers from %s to %s" % (from_list, to_list)
        logging.basicConfig(level=logging.DEBUG)
        for task in copy_subscribers(from_list, to_list):
            print task
            if not dry_run:
                r = task.delay()
                print r
                time.sleep(1)
