# coding: utf-8

import sys
from django.core.management.base import BaseCommand
from django.db.models import get_models, get_apps

class Command(BaseCommand):
    help = u"Выдает количество объектов в каждой модели каждого аппа"

    def handle(self, *args, **options):
        for app in get_apps():
            for model in get_models(app):
                try:
                    count = model.objects.count()
                except Exception, exc:
                    sys.stderr.write(str(exc) + '\n')
                else:
                    print "%s.%s\t%d" % (app.__name__, model.__name__, count)
