# coding: utf-8

from django.core.management.base import BaseCommand
from mlcore.subscribe.backends.yandex_team.models import YandexTeamBackendContext
from django.db.models import Q
import csv


class Command(BaseCommand):
    help = u"ML-1228: csv с двумя столбцами: passport_name и deafult_email"

    def handle(self, *args, **options):
        with open('info_maillists.csv', 'w') as csvfile:
            for ctx in YandexTeamBackendContext.objects.filter(~Q(maillist__email='')):
                passport_name = ctx.passport_name
                email = ctx.maillist.email
                writer = csv.writer(csvfile, quoting=csv.QUOTE_MINIMAL)
                writer.writerow([passport_name, email])
