# -*- coding: utf-8 -*-

from optparse import make_option

from django.db.models import Count
from django.core.management.base import BaseCommand

from mlcore.ml.models import Subscribers, MailList

class Command(BaseCommand):
    help = 'Deletes all subscription duplicates (i.e. Subscribers entities '\
            'with same user and list)'


    option_list = BaseCommand.option_list
    if '--verbosity' not in [opt.get_opt_string() for opt in BaseCommand.option_list]:
        option_list += make_option('-v', '--verbosity', action='store',
                                   dest='verbosity', default='1',
                                   type='choice', choices=['0', '1', '2'],
                                   help=('Verbosity level; 0=minimal output,'
                                         ' 1=normal output, 2=all output; set'
                                         ' to 0 for running by cron daemon'))

    def handle(self, *args, **options):
        try:
            verbosity = int(options.get('verbosity', 1))
        except:
            verbosity = 1

        data = MailList.objects.values_list('subscribers__user', 'id').annotate(
            count=Count('subscribers__user')).filter(count__gt=1)

        duplicate_ids = sum((list(Subscribers.objects
                .filter(user__id=user_id, list__id=list_id)[1:]\
                                  .values_list('id', flat=True))
                             for user_id, list_id, count in data),
            [])
        Subscribers.objects.filter(id__in=duplicate_ids).delete()
        ndeleted = len(duplicate_ids)

        if verbosity > 0:
            return 'deleted %s duplicates\n' % (ndeleted,)
