# encoding: utf-8
from optparse import make_option

from django.core.management import BaseCommand

from mlcore.utils.domain_name import Domain

from ya_directory.api import DirectoryMaillistsOperations


class Command(BaseCommand):
    option_list = BaseCommand.option_list + (
        make_option('-d', '--domain', dest='domain', default='bla'),
    )

    def handle(self, *args, **options):
        """
        Команда для ручной "починки" домена, чтобы сервис Рассылки мог нормально создавать рассылки в этом домене.
        Пока что обрабатываем только домены, чьи MX записи смотрят на большую почту (или не настроены -> считаем
        что у домена будут такие MX).

        Для доменов, MX-ы которых смотрят в Большую почту для организации корпоративной рассылки вида alias@domain
        необходимо и достаточно учетки-рассылки во внешнем паспорте с ящиком alias@domain, учетки-рассылки в
        корповом паспорте (xxx@yandex-team.ru), и форварда alias@domain -> xxx@yandex-team.ru.

        Однако, поскольку заведение учеток во внешнем паспорте и управление внешними доменами должно делаться через
        АПИ Директории, возникает ряд связанных условий, касающихся того как устроена логика в Директории.
        Необходимо соблюдение следующих условий:
            1.  в коннекте существует организация, владеющая доменом domain - не просто привязан, а именно подтвержден,
                иначе в организации нельзя будет создавать учетки, а только приглашать в неё существующие
            2.  у пользователя maillists есть возможность создавать в организации группы
                чтобы соблюсти это условие мы требуем, чтобы для организации и пункта 1 юзер maillists является
                либо администратором либо заместителем администратора
            3.  в организации включен сервис Рассылки, чтобы группы в организации создавались с соответствующими
                учетками во внешнем паспорте - не можем исправить сами :(
        """

        domain = Domain(name=options['domain'])
        domain.validate()
        assert domain.is_pdd_mx or domain.has_no_mx

        directory_operations = DirectoryMaillistsOperations()
        org_id = directory_operations.get_or_create_organization_with_domain_occupied(domain.name)
        if not directory_operations.has_admin_role(org_id):
            # main reason for command
            directory_operations._fix_access_to_org(org_id)

        if not directory_operations.has_admin_role(org_id):
            raise RuntimeWarning('Сервис рассылки отключен')
