# coding: utf-8
from __future__ import unicode_literals

from django.core.management.base import BaseCommand
from mlcore.ml.models import DirectForwards, MailList
from mlcore.tasks.base import create_direct_forward
from mlcore.interaction.yfurita import Forward


def remove_furita_forwards():
    ctrl = Forward()
    maillists = set((x.maillist_id for x in DirectForwards.objects.filter(is_deleted=False).all()))
    for ml_id in maillists:
        ml = MailList.objects.get(pk=ml_id)
        for rule in ctrl.detailed(ml):
            ctrl.remove(ml, rule['id'])
        print "Удалены форварды для списка рассылки %s" % ml.email


class Command(BaseCommand):
    help = u"Разовый скрипт для переноса форвардов из Furita"

    def handle(self, *args, **options):
        remove_furita_forwards()
        for fwd in DirectForwards.objects.filter(is_deleted=False).all():
            create_direct_forward({}, fwd.id)
            print "Создана прямая пересылка для рассылки %s на адрес %s" % (fwd.maillist.email, fwd.email)
