# -*- coding: utf-8 -*-
from django_intranet_stuff.utils.plocker import PLockedCommand

from mlcore.ml.models import MailList

class Command(PLockedCommand):
    help = 'Resync parent_id in MailList model by names'

    def plocked_handle(self, *args, **options):

        items = {}

        for maillist in MailList.objects\
                    .order_by('name'):

            name = maillist.name.strip('.')

            if '.' in name and '@' not in name:
                parent_name, alias = name.rsplit('.', 1)
                if parent_name not in items:
                    #raise ValueError("missing parent for %s: %s" % (name, parent_name))
                    print "missing parent for %s: %s" % (name, parent_name)
                    continue
                parent = items[parent_name]

                maillist.parent_id = parent.id
                maillist.save()
                items[name] = maillist
            else:
                items[name] = maillist
