# encoding: utf-8

from django.core.management.base import BaseCommand
from mlcore.utils.getters import get_list
from mlcore.subscribe.backends.yandex_team.models import YandexTeamBackendContext
from mlcore.ml.models import MailList
from mlcore.tasks import low_level, base
from optparse import make_option
from django.db.models import Q
from mlcore.subscribe import subscription_type as sub_type


import logging
logger = logging.getLogger(__name__)


def unsubscribe_from_cmail(maillist):
    logger.info("Unsubscribe inbox-users")
    context = {
        'initiator': 'use_cmail',
        'comment': 'Unsubscribe all inbox-users from %s' % maillist.name,
    }
    passport_maillist = YandexTeamBackendContext.objects.get(fsuid=maillist.fsuid, fid=maillist.fid)
    imap_email = passport_maillist.passport_name + '@mail.yandex-team.ru'

    # отписываем только тех, кто подписан во входящие
    for s in maillist.subscribers_set.filter(stype__in=[sub_type.INBOX, sub_type.BOTH]):
        low_level.unsubscribe_cmail.delay(context, s.user, maillist, sub_type.INBOX)
    for s in maillist.emailsubscriber_set.filter(~Q(email=imap_email)):
        low_level.unsubscribe_cmail.delay(context, s.email, maillist, sub_type.INBOX)


def subscribe_imap_email(maillist):
    passport_maillists = YandexTeamBackendContext.objects.filter(fsuid=maillist.fsuid, fid=maillist.fid)
    if passport_maillists:
        passport_maillist = passport_maillists[0]
        imap_email = passport_maillist.passport_name + '@mail.yandex-team.ru'

        context = {
            'initiator': maillist.email,
            'comment': u'Подписка imap_email из-за галочки use_cmail: %s' % maillist.email,
        }
        base.subscribe_cmail.delay(context, imap_email, maillist, sub_type.INBOX)
    else:
        logger.info("No such maillist in passport")

class Command(BaseCommand):
    help = u"Устанаваливаем параметр use_cmail для рассылок. " \
           u"d - При установке параметра все подписички в cmail - отписываются"

    option_list = BaseCommand.option_list + (
        make_option(
            '-m',
            '--maillists',
            dest='input_maillists',
            default='',
            help='Set use_cmail=False for input maillists'
        ),
        make_option(
            '-d',
            '--delete',
            dest='del_inbox',
            action='store_true',
            default=False,
            help='Inbox-subscribers would be deleted from cmail'
        ),
        make_option(
            '-f',
            '--force',
            dest='force',
            action='store_true',
            default=False,
            help='Set use_cmail=False for all maillists'
        ),
    )

    def handle(self, *args, **options):
        if options.get('input_maillists'):
            names = [name.strip() for name in options.get('input_maillists').split(',')]
        elif options.get('force'):
            names = [ml.name.strip() for ml in MailList.objects.all()]
        else:
            names = []

        for name in names:
            try:
                maillist = get_list(name)
                if options.get('del_inbox'):
                    unsubscribe_from_cmail(maillist)
                maillist.use_cmail = False
                maillist.save()
                subscribe_imap_email(maillist)
            except (TypeError, YandexTeamBackendContext.DoesNotExist) as err:
                logger.info("no such maillist with name %s" % name)
                continue
