# coding: utf-8

import logging
from django.core.management.base import BaseCommand
from django.utils.encoding import force_unicode
from mlcore.interaction.ymail import YmailBackend
from mlcore.ml.models import MailList

logger = logging.getLogger(__name__)


def sync_archiving_options(maillist, mlapi_data, ymail):
    # <mlapi_data> is {u'keep_days': None, u'enabled': False, u'type': 'clean'}

    if mlapi_data.get('enabled'):
        # Если в mlapi включено, то надо поставить галки в ml
        if (not maillist.is_archive) or (maillist.before_clean != mlapi_data.get('keep_days')):
            logging.info("Updating data in ML (%s): %s/%s/%s -> %s/%s/%s", maillist, maillist.is_archive,
                                                                      maillist.before_clean, maillist.archiving_type,
                                                                      mlapi_data.get('enabled'), mlapi_data.get('keep_days'),
                                                                      mlapi_data.get('type'))

            MailList.objects.filter(id=maillist.id).update(is_archive=mlapi_data.get('enabled'),
                                                           before_clean=mlapi_data.get('keep_days'),
                                                           archiving_type=mlapi_data.get('type'))

    else:
        # Если в mlapi выключено...
        if maillist.is_archive:
            # ...а в ML включено, то надо включить в mlapi
            logging.info("Setting archiving in mlapi (%s): %s/%s/%s -> %s/%s/%s", maillist, mlapi_data.get('enabled'),
                                                                             mlapi_data.get('keep_days'),
                                                                             mlapi_data.get('type'),
                                                                             maillist.is_archive,
                                                                             maillist.before_clean,
                                                                             maillist.archiving_type)

            ymail.set_archiving_options(maillist, enable=maillist.is_archive, keep_days=maillist.before_clean,
                                        archiving_type=maillist.archiving_type)


class Command(BaseCommand):
    help = u"Синхронизация свойств авторотируемости с ymail_api"

    def handle(self, *args, **options):
        ymail = YmailBackend()
        for ml in MailList.objects.filter(is_deleted=False):
            try:
                resp = ymail.get_archiving_options(ml)
                sync_archiving_options(ml, resp, ymail)
            except Exception as exc:
                logging.error(u"Ymail error: %s, failed in archiving options %s. Ignore.",
                    force_unicode(exc.message, errors='ignore'),
                    ml.name)
                continue
