# coding: utf-8
import time
from optparse import make_option

from django.core.management.base import BaseCommand
from mlcore.ml.models import Subscribers
from django_intranet_stuff.models import Department, Staff
from mlcore.utils.getters import get_user
from mlcore.tasks import operations

"""
    Пример запуска:
    manage.py sync_assessors > log.txt
"""

def read_exclude_file(filename):
    with open(filename, mode='r') as f:
        for line in f:
            if line:
                line = line.strip()
                if line.endswith('@'):
                    yield line[:-1].lower()
                else:
                    raise RuntimeError('Invalid line (%s) in excludes file %s', line, filename)


class Command(BaseCommand):
    help = u"Разовый скрипт для ML-1095: Отображаем и удаляем подписки, на которые ассессор не должен быть подписан"
    option_list = BaseCommand.option_list + (
        make_option('-u', '--unsubscribe', action='store_true', dest='unsubscribe',
                    default=False, help="Assessors would unsubscribed from exclude_maillists"),
    )

    def handle(self, *args, **options):
        assert len(args) > 0, "Укажите имя файла со списками-исключениями"
        filename = args[0] 
        exclude_maillists = set(read_exclude_file(filename))

        # собираем подписки с рассылками, на которые не должен быть подписан асессор
        context = {
            'initiator': 'admin',
            'comment': 'Unsubscribe assessors (ML-1095)',
        }
        for dep in Department.objects.filter(url__startswith='as'):
            for assessor in Staff.objects.filter(department=dep):
                user = get_user(assessor)
                for s in Subscribers.objects.filter(user=user):
                    if s.list.name not in exclude_maillists:
                        print s
                        if options['unsubscribe']:
                            operations.unsubscribe.delay(context, user, s.list)
                            # Магия - отписываем одного целовека в секунду, чтобы у cmail процессор не перегрелся
                            time.sleep(1)
