# -*- coding: utf-8 -*-
import logging
from optparse import make_option

from django.core.management.base import BaseCommand
from django.db import transaction
from mlcore.subscribe.backends.yandex_team.models import YandexTeamBackendContext
from mlcore.interaction.ymail import YmailBackend

logger = logging.getLogger(__name__)


@transaction.atomic
def sync_fids(ctx, ymail):
    try:
        folders = ymail.folders(ctx.maillist)
        # если количество общих папок == 1, то все ок, если == 0,
        # то какая-то старая рассылка - забьем пока на нее
        # если > 1, то нужно из списка выбрать нужную нам папку с корректным fid-ом
        if len(folders) == 1:
            fid = folders[0]['fid']
        elif len(folders) > 1:
            for folder in folders:
                maillist_name = ctx.maillist.name
                if folder['fname'] == maillist_name and folder['path'] == 'Yandex|'+maillist_name:
                    fid = folder['fid']
            if not fid:  # если ни название, ни путь в ymail не совпадает с данными из ml, то берем первый fid
                fid = folders[0]['fid']
        else:  # len(folders) < 1
            fid = None
    except Exception:
        logger.exception("Problems with ymail")
    else:
        ctx.maillist.fid = fid
        ctx.maillist.save()

        ctx.fid = fid
        ctx.save()


class Command(BaseCommand):
    help = "Sync list fids from mail.yandex-team.ru"
    option_list = BaseCommand.option_list + (
        make_option('-f', '--force', action='store_true', dest='use_force',
                    default=False, help="Sync fid for all maillists"),
    )

    def handle(self, *args, **options):
        force = options.get('use_force', False)
        contexts = YandexTeamBackendContext.objects.exclude(fsuid=None)

        if not force:
            contexts = contexts.filter(fid=None)

        ymail = YmailBackend()
        for ctx in contexts:
            sync_fids(ctx, ymail)
