# coding: utf-8
import logging
import sys
import os

logger = logging.getLogger(__name__)

#sys.path = ['/etc/yandex/tools-maillists',
#            '/usr/lib/yandex/maillists/lib/python2.7/',
#            '/etc/yandex/tools-maillists/celery/',
#            ] + sys.path

os.environ.setdefault("DJANGO_SETTINGS_MODULE", "settings")
import maillists
sys.path = [os.path.dirname(maillists.__file__)] + sys.path

from django.core.management.base import BaseCommand
from mlcore.interaction.ymail import YmailBackend
from mlcore.ml.models import MailList, Subscribers
from django.core.exceptions import ObjectDoesNotExist, MultipleObjectsReturned
from django.db.utils import IntegrityError

from optparse import make_option
from mlcore.subscribe import subscription_type as sub_type
from mlcore.tasks.low_level import (subscribe_ymail, subscribe_ml,
                       unsubscribe_ymail, unsubscribe_ml,
                       create_passport_user,
                       create_maillist_ml, create_maillist_ymail,
                       rnd_delay,
                       pdd_create_maillist, pdd_register_domain, passport_set_altdomain,
                       check_yateam_blackbox_user, check_big_blackbox_user)
from mlcore.utils.getters import get_user, get_list, get_suid, get_staff, get_list_suid

from django.conf import settings
dry_run = settings.DRY_RUN

from mlcore.subscribe.backends.yandex_team.base import YandexTeamBackendContext



OPTIONS = [

    {'args': ["", "--lists"],
     'kwargs': dict(dest="lists", default=None, help="Maillists to check (e.g. bbs,staff)"),
     },

    {'args': ["", "--passport"],
     'kwargs': dict(dest="passport", action="store_true", default=False,
                    help="Recreate maillist in passport")
    },

    {'args': ("", "--imap"),
     'kwargs': dict( dest="imap", action="store_true", default=False,
                     help="Recreate maillist in imap"),
     },

    {'args': ("", "--resubscribe"),
     'kwargs': dict(dest="resubscribe", action="store_true", default=False,
                     help="Resubscribe in imap"),
     }

]


class Command(BaseCommand):
    help = u"Пересоздать рассылку в паспорте и в imap"

    option_list = BaseCommand.option_list + tuple( [make_option(*o['args'], **o['kwargs']) for o in OPTIONS ] )

    def _get_full_data(self, maillist):
        email = maillist.email
        login, domain = email.split('@')
        responsible = [o.user.email for o in maillist.owners]

        try:
            backend = YandexTeamBackendContext.objects.get(backend_type='yandex_team', maillist=maillist)
            imap_name = backend.passport_name
        except Exception as exc:
            print __name__, exc
            if domain != 'yandex-team.ru':
                raise NotImplementedError(u'Допиши код для работы с не-yandexteam рассылками')
            imap_name = login

        data = {'domain': domain,
                'responsible': responsible,
                'name': imap_name,
                'is_internal': maillist.is_internal,
                'email': maillist.email,
                'is_open': maillist.is_open,
                'imap_name': imap_name
                }
        return data

    def sync_passport(self, maillist):
        data = self._get_full_data(maillist)
        t = create_passport_user.delay({'initiator': 'lavrinenko'}, data)
        print "create_passport_user task=%s" % t, t

    def sync_imap(self, maillist):
        data = self._get_full_data(maillist)
        t = create_maillist_ymail.delay({'initiator': 'lavrinenko'}, data)
        print "create_maillist_ymail task=%s" % t, t

    def resubscribe_imap(self, maillist):
        print dir(maillist)
        for s in Subscribers.objects.filter(list=maillist): # maillist.subscribers.filter():
            if s.is_imap:
                t = subscribe_ymail.delay(context={'initiator': 'lavrinenko'},
                                          user=s.user,
                                          maillist=maillist,
                                          type=sub_type.IMAP)
                print s, t

    def handle(self, *args, **options):
        print options
        for name in options['lists'].split(','):
            maillist = get_list(name)
            print self._get_full_data(maillist)
            if options['passport']:
                self.sync_passport(maillist)
            if options['imap']:
                self.sync_imap(maillist)
            if options['resubscribe']:
                self.resubscribe_imap(maillist)

if __name__ == "__main__":
    #Command().handle(lists='man_staff@yandex-team.com', passport=False, imap=False, resubscribe=True)
    Command().handle(lists='invoices_man@yandex-team.com', passport=False, imap=False, resubscribe=True)
