# coding: utf-8

from django.core.management.base import BaseCommand
from mlcore.interaction.ymail import YmailBackend
from mlcore.ml.models import MailList
from django.core.exceptions import ObjectDoesNotExist, MultipleObjectsReturned
from django.db.utils import IntegrityError
import logging

from django.conf import settings
dry_run = settings.DRY_RUN

if dry_run:
    from treelib import Tree


logger = logging.getLogger(__name__)

COUNT_ERR_DBKEY = 0
mlfails = list()

class Command(BaseCommand):
    help = u"Синхронизация родителей c ymail_api"

    def add_node(self, node):
        global COUNT_ERR_DBKEY, mlfails
        try:
            ml = MailList.objects.get(fsuid=node["uname"])
            if node["parent_uname"] != 0:
                ml.parent = MailList.objects.get(fsuid=node["parent_uname"])
                ml.save()
        except ObjectDoesNotExist:
            logger.exception(u"Such maillist DoesNotExist: %s, %d, %d", node["fname"], node["uname"], node["parent_uname"])
        except MultipleObjectsReturned:
            logger.exception(u"Such maillist MultipleObjectsReturned: %s, %d, %d", node["fname"], node["uname"], node["parent_uname"])
        except IntegrityError as ex:
            logger.exception("%s", ex)
            COUNT_ERR_DBKEY += 1
            mlfails.append((node["uname"], node["parent_uname"]))

        if dry_run:
            self.tree.create_node(node["fname"], node["uname"], parent=node["parent_uname"])
        children = self.ymail.get_children(node["uname"])
        for n in children:
            self.add_node(n)

    def sync_from_root(self):
        all_maillists = self.ymail.get_all_children()
        if dry_run:
            self.tree.create_node("Yandex", 0)
        for node in all_maillists:
            self.add_node(node)
        if dry_run:
            self.tree.show(idhidden=False)
            self.tree.save2file("all_YandexML.tree", idhidden=False)

    def sync_from_support(self):
        self.tree.create_node("support", 1120000000030473) # root node
        support_children = self.ymail.get_children(1120000000030473)
        for node in support_children:
            self.add_node(node)
        self.tree.show(idhidden=False)
        self.tree.save2file("all_SupportML.tree", idhidden=False)


    def handle(self, *args, **options):
        global COUNT_ERR_DBKEY, mlfails

        if dry_run:
            self.tree = Tree()
        self.ymail = YmailBackend()

        if len(args) == 0:
            self.sync_from_root()
        elif args[0] == "test" and dry_run:
            print "test"
            self.sync_from_support()

        if COUNT_ERR_DBKEY > 0:
            print "COUNT_ERR_DBKEY", COUNT_ERR_DBKEY
            # печатем имя той рассылки и ее родителя, которая зафейлилась
            for name, parent in mlfails:
                print name, parent
