# -*- coding: utf-8 -*-
import logging

from django.core.management.base import BaseCommand
from django_intranet_stuff.models import Staff

from mlcore.utils.blackbox_util import get_uid

logger = logging.getLogger(__name__)


class Command(BaseCommand):
    help = "Sync staff uids"

    def handle(self, *args, **options):
        for staff in Staff.objects.all():
            staff.uid = get_uid(staff.login)
            staff.save(update_fields=['uid'])
