# coding: utf-8

import logging
from django.core.management.base import BaseCommand
from django.utils.encoding import force_unicode
from mlcore.interaction.ymail import YmailBackend, YmailError
from mlcore.interaction.ywmi import YWMIBackend, YWMIError
from mlcore.ml.models import MailList
from mlcore.utils.getters import get_suid

logger = logging.getLogger(__name__)

class Command(BaseCommand):
    help = u"Синхронизация списка подписчиков с ymail"
    ymail = YmailBackend()
    ywmi = YWMIBackend()

    def sync_subscribers(self, maillist):
        try:
            suid_subscribers = self.ymail.subscribers(maillist)
        except YmailError as exc:
            logger.error(u"Ymail error with <subscribers>: %s, %s-list",
                         force_unicode(exc.message, errors='ignore'),
                         maillist.name)
            return

        for user in maillist.subscribers_set.filter().values_list('user__username', flat=True):
            suid = get_suid(user)
            if not suid in suid_subscribers:
                logger.error("%s-maillist: %s-user with %s-suid not in Ymail.Subscribers",
                             maillist.name, user, suid)
                try:
                    self.ywmi.subscribe(user, maillist)
                except YWMIError as exc:
                    logger.error(u"YWMI error with <subscribe>: %s, %s-list",
                                 force_unicode(exc.message, errors='ignore'),
                                 maillist.name)

    def handle(self, *args, **options):
        for maillist in MailList.objects.filter(is_deleted=False):
            self.sync_subscribers(maillist)