# coding: utf-8

import logging
from django.core.management.base import BaseCommand
from django.utils.encoding import force_unicode
from mlcore.interaction.ymail import YmailBackend, YmailError
from mlcore.ml.models import MailList
from mlcore.ml.models import Autosubscription, Subscribers
from django.contrib.auth.models import User
from mlcore.utils.getters import get_user, get_list

logger = logging.getLogger(__name__)

class Command(BaseCommand):
    help = u"Синхронизация подписок пользователей с ymail"

    @property
    def ymail(self):
        client = getattr(self, '_ymail_client', None)
        if client is None:
            client = self._ymail_client = YmailBackend()
        return client

    def list_by_suid(self, fsuid):
        return MailList.objects.filter(fsuid=fsuid).all()[0]

    def check_ymail_subscribes(self, user):

        suids_in_ml   = set([ s.list.fsuid for s in Subscribers.objects.filter(user=user, is_imap=True) ])
        suids_in_mail = set([ s['folder_uname'] for s in self.ymail.subscriptions(user=user) ])

        uncommited_subscribes = suids_in_ml - suids_in_mail
        zombie_subscribes = suids_in_mail - suids_in_ml

        print "User=", user
        print "Subscribes in ml:", len(suids_in_ml)
        print ",".join( sorted( [ l.name for l in map(self.list_by_suid, suids_in_ml)  ] ))
        print "Subscribes in imap:", len(suids_in_mail)
        if uncommited_subscribes:
            print "Uncommited subscribes:", len(uncommited_subscribes)
            print ",".join( sorted( [ l.name for l in map(self.list_by_suid, uncommited_subscribes)  ] ) )
        if zombie_subscribes:
            print "Zombie subscribes:", len(zombie_subscribes)
            print ",".join( sorted( [ l.name for l in map(self.list_by_suid, zombie_subscribes)  ] ) )

    def sync_user(self, user):
        return self.check_ymail_subscribes(get_user(user))


    def handle(self, *args, **options):
        # user = get_user('bonifaci')
        # self.check_ymail_subscribes(user)

        for user in User.objects.filter(is_active=True).exclude(email=''):
           self.check_ymail_subscribes(user)
