# encoding: utf-8
import codecs

from django_tanker.management.commands.tankerdownload import Command as TankerDownloadCommand
from django.utils.encoding import force_unicode, smart_str


# Фикс для команды django_tanker/tankerdownload 0.11 в django 1.6
# В django_tanker фикс уже есть, но в стейбл не выкатилось

class Command(TankerDownloadCommand):
    can_import_settings = True

    def handle_language(self, lang, keyset, path):
        if keyset not in self.tanker.list():
            return

        print smart_str(
            u'Downloading %s[%s] to: %s' % tuple(map(force_unicode, (keyset, lang, path))))

        content = self.tanker.download(
            keyset, lang,
            status=self.options['status'],
            key_not_language=self.options['key_not_language'],
            ref=self.options['branch']
        )

        if not self.options['dry_run']:
            with codecs.open(path, 'w', 'utf-8') as outp:
                outp.write(content)
