# encoding: utf-8
import datetime
from south.db import db
from south.v2 import SchemaMigration
from django.db import models


class Migration(SchemaMigration):

    def forwards(self, orm):
        
        # Adding model 'MailList'
        db.create_table('wakka_maillists', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('name', self.gf('django.db.models.fields.CharField')(max_length=255, unique=True, null=True, db_index=True)),
            ('email', self.gf('django.db.models.fields.EmailField')(max_length=255, null=True)),
            ('letter', self.gf('django.db.models.fields.CharField')(max_length=1, null=True, db_index=True)),
            ('info', self.gf('django.db.models.fields.TextField')(null=True)),
            ('info_modified', self.gf('django.db.models.fields.BooleanField')(default=False)),
            ('max_length', self.gf('django.db.models.fields.PositiveIntegerField')()),
            ('fid', self.gf('django.db.models.fields.BigIntegerField')(null=True, blank=True)),
            ('fsuid', self.gf('django.db.models.fields.BigIntegerField')(null=True, blank=True)),
            ('is_imap', self.gf('django.db.models.fields.BooleanField')(default=False)),
            ('is_sub', self.gf('django.db.models.fields.BooleanField')(default=False)),
            ('is_internal', self.gf('django.db.models.fields.BooleanField')(default=True)),
            ('is_open', self.gf('django.db.models.fields.BooleanField')(default=False)),
            ('is_manual', self.gf('django.db.models.fields.BooleanField')(default=False)),
            ('is_sms', self.gf('django.db.models.fields.BooleanField')(default=False)),
            ('is_hidden', self.gf('django.db.models.fields.BooleanField')(default=False)),
            ('is_deleted', self.gf('django.db.models.fields.BooleanField')(default=False)),
            ('is_mandatory', self.gf('django.db.models.fields.BooleanField')(default=False)),
            ('imap_users', self.gf('django.db.models.fields.PositiveIntegerField')(default=0)),
            ('sub_users', self.gf('django.db.models.fields.PositiveIntegerField')(default=0)),
            ('created_dt', self.gf('django.db.models.fields.DateTimeField')(null=True, db_index=True)),
            ('created_at', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now)),
            ('modified_at', self.gf('django.db.models.fields.DateTimeField')(auto_now=True, blank=True)),
        ))
        db.send_create_signal('ml', ['MailList'])

        # Adding model 'BackendContext'
        db.create_table('ml_backendcontext', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('backend_type', self.gf('django.db.models.fields.CharField')(max_length=32, null=True, db_index=True)),
            ('maillist', self.gf('django.db.models.fields.related.ForeignKey')(related_name='backends', to=orm['ml.MailList'])),
            ('is_imap', self.gf('django.db.models.fields.BooleanField')(default=False)),
            ('is_sub', self.gf('django.db.models.fields.BooleanField')(default=False)),
        ))
        db.send_create_signal('ml', ['BackendContext'])

        # Adding unique constraint on 'BackendContext', fields ['backend_type', 'maillist']
        db.create_unique('ml_backendcontext', ['backend_type', 'maillist_id'])

        # Adding model 'Subscribers'
        db.create_table('wakka_subscribers', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('list', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['ml.MailList'])),
            ('user', self.gf('django.db.models.fields.related.ForeignKey')(related_name='subscriptions', to=orm['auth.User'])),
            ('is_imap', self.gf('django.db.models.fields.BooleanField')(default=False)),
            ('is_sub', self.gf('django.db.models.fields.BooleanField')(default=False)),
            ('stype', self.gf('django.db.models.fields.CharField')(max_length=15, null=True, db_index=True)),
            ('created_at', self.gf('django.db.models.fields.DateTimeField')(auto_now_add=True, db_index=True, blank=True)),
        ))
        db.send_create_signal('ml', ['Subscribers'])

        # Adding model 'EmailSubscriber'
        db.create_table('mailarchive_emailsubscriber', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('list', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['ml.MailList'])),
            ('email', self.gf('django.db.models.fields.EmailField')(max_length=255, null=True, db_index=True)),
            ('created_at', self.gf('django.db.models.fields.DateTimeField')(auto_now_add=True, db_index=True, blank=True)),
        ))
        db.send_create_signal('ml', ['EmailSubscriber'])

        # Adding model 'Owner'
        db.create_table('mailarchive_owner', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('user', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['auth.User'])),
            ('list', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['ml.MailList'])),
            ('created', self.gf('django.db.models.fields.DateTimeField')(auto_now_add=True, blank=True)),
        ))
        db.send_create_signal('ml', ['Owner'])

        # Adding unique constraint on 'Owner', fields ['user', 'list']
        db.create_unique('mailarchive_owner', ['user_id', 'list_id'])

        # Adding model 'PendingBackendOperation'
        db.create_table('mailarchive_pendingbackendoperation', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('created', self.gf('django.db.models.fields.DateTimeField')(auto_now_add=True, blank=True)),
            ('is_notified', self.gf('django.db.models.fields.BooleanField')(default=False)),
            ('is_succeed', self.gf('django.db.models.fields.BooleanField')(default=False)),
            ('attempts', self.gf('django.db.models.fields.PositiveSmallIntegerField')(default=0)),
            ('max_attempts', self.gf('django.db.models.fields.PositiveSmallIntegerField')(default=4)),
            ('last_failure_info', self.gf('django.db.models.fields.CharField')(max_length=256, null=True, blank=True)),
            ('backend_type', self.gf('django.db.models.fields.CharField')(max_length=32, null=True)),
            ('operation_type', self.gf('django.db.models.fields.CharField')(max_length=32, null=True)),
            ('operation_args', self.gf('django.db.models.fields.CharField')(max_length=256, null=True)),
        ))
        db.send_create_signal('ml', ['PendingBackendOperation'])

        # Adding model 'PendingSubscribeOperation'
        db.create_table('mailarchive_pendingsubscribeoperation', (
            ('pendingbackendoperation_ptr', self.gf('django.db.models.fields.related.OneToOneField')(to=orm['ml.PendingBackendOperation'], unique=True, primary_key=True)),
            ('list', self.gf('django.db.models.fields.related.ForeignKey')(related_name='pending_subscriptions', to=orm['ml.MailList'])),
            ('user', self.gf('django.db.models.fields.related.ForeignKey')(related_name='pending_subscriptions', to=orm['auth.User'])),
        ))
        db.send_create_signal('ml', ['PendingSubscribeOperation'])

    def backwards(self, orm):
        
        # Removing unique constraint on 'Owner', fields ['user', 'list']
        db.delete_unique('mailarchive_owner', ['user_id', 'list_id'])

        # Removing unique constraint on 'BackendContext', fields ['backend_type', 'maillist']
        db.delete_unique('ml_backendcontext', ['backend_type', 'maillist_id'])

        # Deleting model 'MailList'
        db.delete_table('wakka_maillists')

        # Deleting model 'BackendContext'
        db.delete_table('ml_backendcontext')

        # Deleting model 'Subscribers'
        db.delete_table('wakka_subscribers')

        # Deleting model 'EmailSubscriber'
        db.delete_table('mailarchive_emailsubscriber')

        # Deleting model 'Owner'
        db.delete_table('mailarchive_owner')

        # Deleting model 'PendingBackendOperation'
        db.delete_table('mailarchive_pendingbackendoperation')

        # Deleting model 'PendingSubscribeOperation'
        db.delete_table('mailarchive_pendingsubscribeoperation')

    models = {
        'auth.group': {
            'Meta': {'object_name': 'Group'},
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '80', 'unique': 'True', 'null': 'True'}),
            'permissions': ('django.db.models.fields.related.ManyToManyField', [], {'symmetrical': 'False', 'to': "orm['auth.Permission']", 'null': 'True', 'blank': 'True'})
        },
        'auth.permission': {
            'Meta': {'ordering': "('content_type__app_label', 'content_type__model', 'codename')", 'unique_together': "(('content_type', 'codename'),)", 'object_name': 'Permission'},
            'codename': ('django.db.models.fields.CharField', [], {'max_length': '100', 'null': 'True'}),
            'content_type': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['contenttypes.ContentType']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '50', 'null': 'True'})
        },
        'auth.user': {
            'Meta': {'object_name': 'User'},
            'date_joined': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now'}),
            'email': ('django.db.models.fields.EmailField', [], {'max_length': '75', 'null': 'True', 'blank': 'True'}),
            'first_name': ('django.db.models.fields.CharField', [], {'max_length': '30', 'null': 'True', 'blank': 'True'}),
            'groups': ('django.db.models.fields.related.ManyToManyField', [], {'symmetrical': 'False', 'to': "orm['auth.Group']", 'null': 'True', 'blank': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'is_active': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'is_staff': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'is_superuser': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'last_login': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now'}),
            'last_name': ('django.db.models.fields.CharField', [], {'max_length': '30', 'null': 'True', 'blank': 'True'}),
            'password': ('django.db.models.fields.CharField', [], {'max_length': '128', 'null': 'True'}),
            'user_permissions': ('django.db.models.fields.related.ManyToManyField', [], {'symmetrical': 'False', 'to': "orm['auth.Permission']", 'null': 'True', 'blank': 'True'}),
            'username': ('django.db.models.fields.CharField', [], {'max_length': '30', 'unique': 'True', 'null': 'True'})
        },
        'contenttypes.contenttype': {
            'Meta': {'ordering': "('name',)", 'unique_together': "(('app_label', 'model'),)", 'object_name': 'ContentType', 'db_table': "'django_content_type'"},
            'app_label': ('django.db.models.fields.CharField', [], {'max_length': '100', 'null': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'model': ('django.db.models.fields.CharField', [], {'max_length': '100', 'null': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '100', 'null': 'True'})
        },
        'ml.backendcontext': {
            'Meta': {'unique_together': "[('backend_type', 'maillist')]", 'object_name': 'BackendContext'},
            'backend_type': ('django.db.models.fields.CharField', [], {'max_length': '32', 'null': 'True', 'db_index': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'is_imap': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'is_sub': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'maillist': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'backends'", 'to': "orm['ml.MailList']"})
        },
        'ml.emailsubscriber': {
            'Meta': {'object_name': 'EmailSubscriber', 'db_table': "'mailarchive_emailsubscriber'"},
            'created_at': ('django.db.models.fields.DateTimeField', [], {'auto_now_add': 'True', 'db_index': 'True', 'blank': 'True'}),
            'email': ('django.db.models.fields.EmailField', [], {'max_length': '255', 'null': 'True', 'db_index': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'list': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['ml.MailList']"})
        },
        'ml.maillist': {
            'Meta': {'ordering': "('name',)", 'object_name': 'MailList', 'db_table': "'wakka_maillists'"},
            'created_at': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now'}),
            'created_dt': ('django.db.models.fields.DateTimeField', [], {'null': 'True', 'db_index': 'True'}),
            'email': ('django.db.models.fields.EmailField', [], {'max_length': '255', 'null': 'True'}),
            'fid': ('django.db.models.fields.BigIntegerField', [], {'null': 'True', 'blank': 'True'}),
            'fsuid': ('django.db.models.fields.BigIntegerField', [], {'null': 'True', 'blank': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'imap_users': ('django.db.models.fields.PositiveIntegerField', [], {'default': '0'}),
            'info': ('django.db.models.fields.TextField', [], {'null': 'True'}),
            'info_modified': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'is_deleted': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'is_hidden': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'is_imap': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'is_internal': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'is_mandatory': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'is_manual': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'is_open': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'is_sms': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'is_sub': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'letter': ('django.db.models.fields.CharField', [], {'max_length': '1', 'null': 'True', 'db_index': 'True'}),
            'max_length': ('django.db.models.fields.PositiveIntegerField', [], {}),
            'modified_at': ('django.db.models.fields.DateTimeField', [], {'auto_now': 'True', 'blank': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '255', 'unique': 'True', 'null': 'True', 'db_index': 'True'}),
            'sub_users': ('django.db.models.fields.PositiveIntegerField', [], {'default': '0'})
        },
        'ml.owner': {
            'Meta': {'unique_together': "[('user', 'list')]", 'object_name': 'Owner', 'db_table': "'mailarchive_owner'"},
            'created': ('django.db.models.fields.DateTimeField', [], {'auto_now_add': 'True', 'blank': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'list': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['ml.MailList']"}),
            'user': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['auth.User']"})
        },
        'ml.pendingbackendoperation': {
            'Meta': {'ordering': "('created',)", 'object_name': 'PendingBackendOperation', 'db_table': "'mailarchive_pendingbackendoperation'"},
            'attempts': ('django.db.models.fields.PositiveSmallIntegerField', [], {'default': '0'}),
            'backend_type': ('django.db.models.fields.CharField', [], {'max_length': '32', 'null': 'True'}),
            'created': ('django.db.models.fields.DateTimeField', [], {'auto_now_add': 'True', 'blank': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'is_notified': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'is_succeed': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'last_failure_info': ('django.db.models.fields.CharField', [], {'max_length': '256', 'null': 'True', 'blank': 'True'}),
            'max_attempts': ('django.db.models.fields.PositiveSmallIntegerField', [], {'default': '4'}),
            'operation_args': ('django.db.models.fields.CharField', [], {'max_length': '256', 'null': 'True'}),
            'operation_type': ('django.db.models.fields.CharField', [], {'max_length': '32', 'null': 'True'})
        },
        'ml.pendingsubscribeoperation': {
            'Meta': {'ordering': "('created',)", 'object_name': 'PendingSubscribeOperation', 'db_table': "'mailarchive_pendingsubscribeoperation'", '_ormbases': ['ml.PendingBackendOperation']},
            'list': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'pending_subscriptions'", 'to': "orm['ml.MailList']"}),
            'pendingbackendoperation_ptr': ('django.db.models.fields.related.OneToOneField', [], {'to': "orm['ml.PendingBackendOperation']", 'unique': 'True', 'primary_key': 'True'}),
            'user': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'pending_subscriptions'", 'to': "orm['auth.User']"})
        },
        'ml.subscribers': {
            'Meta': {'object_name': 'Subscribers', 'db_table': "'wakka_subscribers'"},
            'created_at': ('django.db.models.fields.DateTimeField', [], {'auto_now_add': 'True', 'db_index': 'True', 'blank': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'is_imap': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'is_sub': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'list': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['ml.MailList']"}),
            'stype': ('django.db.models.fields.CharField', [], {'max_length': '15', 'null': 'True', 'db_index': 'True'}),
            'user': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'subscriptions'", 'to': "orm['auth.User']"})
        }
    }

    complete_apps = ['ml']
