# -*- coding: utf-8 -*-
import datetime
from south.db import db
from south.v2 import SchemaMigration
from django.db import models


class Migration(SchemaMigration):

    def forwards(self, orm):
        # Adding model 'LoginRedirect'
        db.create_table('ml_loginredirect', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('staff', self.gf('django.db.models.fields.related.ForeignKey')(related_name='login_redirects', to=orm['django_intranet_stuff.Staff'])),
            ('redirect_to', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['django_intranet_stuff.Staff'])),
        ))
        db.send_create_signal('ml', ['LoginRedirect'])


    def backwards(self, orm):
        # Deleting model 'LoginRedirect'
        db.delete_table('ml_loginredirect')


    models = {
        'auth.group': {
            'Meta': {'object_name': 'Group'},
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '80'}),
            'permissions': ('django.db.models.fields.related.ManyToManyField', [], {'to': "orm['auth.Permission']", 'symmetrical': 'False', 'blank': 'True'})
        },
        'auth.permission': {
            'Meta': {'ordering': "('content_type__app_label', 'content_type__model', 'codename')", 'unique_together': "(('content_type', 'codename'),)", 'object_name': 'Permission'},
            'codename': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'content_type': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['contenttypes.ContentType']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '50'})
        },
        'auth.user': {
            'Meta': {'object_name': 'User'},
            'date_joined': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now'}),
            'email': ('django.db.models.fields.EmailField', [], {'max_length': '75', 'blank': 'True'}),
            'first_name': ('django.db.models.fields.CharField', [], {'max_length': '30', 'blank': 'True'}),
            'groups': ('django.db.models.fields.related.ManyToManyField', [], {'to': "orm['auth.Group']", 'symmetrical': 'False', 'blank': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'is_active': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'is_staff': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'is_superuser': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'last_login': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now'}),
            'last_name': ('django.db.models.fields.CharField', [], {'max_length': '30', 'blank': 'True'}),
            'password': ('django.db.models.fields.CharField', [], {'max_length': '128'}),
            'user_permissions': ('django.db.models.fields.related.ManyToManyField', [], {'to': "orm['auth.Permission']", 'symmetrical': 'False', 'blank': 'True'}),
            'username': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '30'})
        },
        'contenttypes.contenttype': {
            'Meta': {'ordering': "('name',)", 'unique_together': "(('app_label', 'model'),)", 'object_name': 'ContentType', 'db_table': "'django_content_type'"},
            'app_label': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'model': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '100'})
        },
        'django_intranet_stuff.city': {
            'Meta': {'object_name': 'City', 'db_table': "'intranet_city'"},
            'color': ('django.db.models.fields.CharField', [], {'default': "'000000'", 'max_length': '6'}),
            'created_at': ('django.db.models.fields.DateTimeField', [], {}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'intranet_status': ('django.db.models.fields.IntegerField', [], {'default': '1'}),
            'modified_at': ('django.db.models.fields.DateTimeField', [], {}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'name_en': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '100', 'blank': 'True'}),
            'native_lang': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '2', 'blank': 'True'}),
            'position': ('django.db.models.fields.IntegerField', [], {'default': '0'})
        },
        'django_intranet_stuff.department': {
            'Meta': {'object_name': 'Department', 'db_table': "'intranet_department'"},
            'bg_color': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '20'}),
            'code': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '20'}),
            'created_at': ('django.db.models.fields.DateTimeField', [], {}),
            'description': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '4096'}),
            'description_en': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '4096'}),
            'en_name': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '255'}),
            'fg_color': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '20'}),
            'from_staff_id': ('django.db.models.fields.PositiveIntegerField', [], {'db_index': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'intranet_status': ('django.db.models.fields.IntegerField', [], {'default': '1'}),
            'jira_project': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '255'}),
            'level': ('django.db.models.fields.PositiveIntegerField', [], {'db_index': 'True'}),
            'lft': ('django.db.models.fields.PositiveIntegerField', [], {'db_index': 'True'}),
            'maillists': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '4096'}),
            'modified_at': ('django.db.models.fields.DateTimeField', [], {}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'name_en': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '255'}),
            'native_lang': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '2', 'blank': 'True'}),
            'parent': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'children'", 'null': 'True', 'to': "orm['django_intranet_stuff.Department']"}),
            'position': ('django.db.models.fields.IntegerField', [], {'default': '0'}),
            'rght': ('django.db.models.fields.PositiveIntegerField', [], {'db_index': 'True'}),
            'short_name': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '255'}),
            'short_name_en': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '255'}),
            'tree_id': ('django.db.models.fields.PositiveIntegerField', [], {'db_index': 'True'}),
            'url': ('django.db.models.fields.CharField', [], {'default': "''", 'unique': 'True', 'max_length': '255'}),
            'wiki_page': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '255'})
        },
        'django_intranet_stuff.group': {
            'Meta': {'unique_together': "[('parent', 'role_scope_id')]", 'object_name': 'Group', 'db_table': "'intranet_group'"},
            'code': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '127', 'db_index': 'True'}),
            'created_at': ('django.db.models.fields.DateTimeField', [], {}),
            'department': ('django.db.models.fields.related.OneToOneField', [], {'to': "orm['django_intranet_stuff.Department']", 'unique': 'True', 'null': 'True', 'blank': 'True'}),
            'description': ('django.db.models.fields.TextField', [], {}),
            'externals_count': ('django.db.models.fields.PositiveIntegerField', [], {'default': '0'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'intranet_status': ('django.db.models.fields.IntegerField', [], {'default': '1'}),
            'level': ('django.db.models.fields.PositiveIntegerField', [], {'db_index': 'True'}),
            'lft': ('django.db.models.fields.PositiveIntegerField', [], {'db_index': 'True'}),
            'members': ('django.db.models.fields.related.ManyToManyField', [], {'related_name': "'in_groups'", 'symmetrical': 'False', 'through': "orm['django_intranet_stuff.GroupMembership']", 'to': "orm['django_intranet_stuff.Staff']"}),
            'modified_at': ('django.db.models.fields.DateTimeField', [], {}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '127', 'db_index': 'True'}),
            'native_lang': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '2', 'blank': 'True'}),
            'parent': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'children'", 'null': 'True', 'to': "orm['django_intranet_stuff.Group']"}),
            'position': ('django.db.models.fields.IntegerField', [], {'default': '0', 'null': 'True'}),
            'rght': ('django.db.models.fields.PositiveIntegerField', [], {'db_index': 'True'}),
            'role_scope_id': ('django.db.models.fields.CharField', [], {'max_length': '127', 'null': 'True', 'blank': 'True'}),
            'service_id': ('django.db.models.fields.PositiveIntegerField', [], {'null': 'True', 'blank': 'True'}),
            'tree_id': ('django.db.models.fields.PositiveIntegerField', [], {'db_index': 'True'}),
            'type': ('django.db.models.fields.PositiveSmallIntegerField', [], {'default': '0'}),
            'url': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '255', 'db_index': 'True'}),
            'yamoney_count': ('django.db.models.fields.PositiveIntegerField', [], {'default': '0'}),
            'yandex_count': ('django.db.models.fields.PositiveIntegerField', [], {'default': '0'})
        },
        'django_intranet_stuff.groupmembership': {
            'Meta': {'unique_together': "(('staff', 'group'),)", 'object_name': 'GroupMembership', 'db_table': "'intranet_groupmembership'"},
            'group': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['django_intranet_stuff.Group']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'joined_at': ('django.db.models.fields.DateTimeField', [], {'auto_now_add': 'True', 'blank': 'True'}),
            'staff': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['django_intranet_stuff.Staff']"})
        },
        'django_intranet_stuff.office': {
            'Meta': {'object_name': 'Office', 'db_table': "'intranet_office'"},
            'address1': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '255'}),
            'address1_en': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '255'}),
            'address2': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '255'}),
            'address2_en': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '255'}),
            'city': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['django_intranet_stuff.City']", 'null': 'True', 'blank': 'True'}),
            'code': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '20'}),
            'color': ('django.db.models.fields.CharField', [], {'max_length': '10'}),
            'coord_x': ('django.db.models.fields.FloatField', [], {'null': 'True'}),
            'coord_y': ('django.db.models.fields.FloatField', [], {'null': 'True'}),
            'created_at': ('django.db.models.fields.DateTimeField', [], {}),
            'fax': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '50'}),
            'from_staff_id': ('django.db.models.fields.PositiveIntegerField', [], {'db_index': 'True'}),
            'have_map': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'intranet_status': ('django.db.models.fields.IntegerField', [], {'default': '1'}),
            'modified_at': ('django.db.models.fields.DateTimeField', [], {}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'name_en': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '255'}),
            'native_lang': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '2', 'blank': 'True'}),
            'phone': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '50'}),
            'position': ('django.db.models.fields.IntegerField', [], {'default': '0'}),
            'tz': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '20'}),
            'zoom': ('django.db.models.fields.PositiveSmallIntegerField', [], {'default': '0'})
        },
        'django_intranet_stuff.staff': {
            'Meta': {'object_name': 'Staff', 'db_table': "'intranet_staff'"},
            'affiliation': ('django.db.models.fields.CharField', [], {'max_length': '32', 'db_index': 'True'}),
            'car': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '100'}),
            'car_num': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '100'}),
            'created_at': ('django.db.models.fields.DateTimeField', [], {}),
            'department': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['django_intranet_stuff.Department']", 'null': 'True'}),
            'domain': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '1'}),
            'en_name': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '255'}),
            'first_name': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '50', 'db_index': 'True'}),
            'first_name_en': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '50', 'db_index': 'True'}),
            'from_staff_id': ('django.db.models.fields.PositiveIntegerField', [], {'default': '0', 'db_index': 'True'}),
            'gender': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '1'}),
            'guid': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '47', 'null': 'True'}),
            'has_exchange': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'hide_middle_name': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'intranet_status': ('django.db.models.fields.IntegerField', [], {'default': '1'}),
            'is_big_boss': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'is_dismissed': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'is_homeworker': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'is_robot': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'join_at': ('django.db.models.fields.DateField', [], {'null': 'True'}),
            'lang_content': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '255'}),
            'lang_ui': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '2'}),
            'last_name': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '100', 'db_index': 'True'}),
            'last_name_en': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '100', 'db_index': 'True'}),
            'login': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '50', 'db_index': 'True'}),
            'login_ld': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '50', 'db_index': 'True'}),
            'login_mail': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '50', 'db_index': 'True'}),
            'middle_name': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '50'}),
            'modified_at': ('django.db.models.fields.DateTimeField', [], {}),
            'native_lang': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '2', 'blank': 'True'}),
            'normal_login': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '50', 'db_index': 'True'}),
            'office': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['django_intranet_stuff.Office']", 'null': 'True'}),
            'position': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '150'}),
            'position_en': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '150'}),
            'tz': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '30'}),
            'user': ('django.db.models.fields.related.OneToOneField', [], {'to': "orm['auth.User']", 'unique': 'True', 'null': 'True'}),
            'work_email': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '100', 'db_index': 'True'})
        },
        'ml.autosubscription': {
            'Meta': {'object_name': 'Autosubscription'},
            'group': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['django_intranet_stuff.Group']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'maillist': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['ml.MailList']"}),
            'stype': ('django.db.models.fields.CharField', [], {'default': "'imap'", 'max_length': '15'})
        },
        'ml.backendcontext': {
            'Meta': {'unique_together': "[('backend_type', 'maillist')]", 'object_name': 'BackendContext'},
            'backend_type': ('django.db.models.fields.CharField', [], {'max_length': '32', 'db_index': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'is_imap': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'is_sub': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'maillist': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'backends'", 'to': "orm['ml.MailList']"})
        },
        'ml.corporatedomain': {
            'Meta': {'object_name': 'CorporateDomain'},
            'domain': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '100'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'})
        },
        'ml.createlistlock': {
            'Meta': {'object_name': 'CreateListLock'},
            'created_at': ('django.db.models.fields.DateTimeField', [], {'auto_now_add': 'True', 'db_index': 'True', 'blank': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '255'})
        },
        'ml.emailsubscriber': {
            'Meta': {'object_name': 'EmailSubscriber', 'db_table': "'mailarchive_emailsubscriber'"},
            'created_at': ('django.db.models.fields.DateTimeField', [], {'auto_now_add': 'True', 'db_index': 'True', 'blank': 'True'}),
            'email': ('django.db.models.fields.EmailField', [], {'max_length': '255', 'db_index': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'list': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['ml.MailList']"})
        },
        'ml.loginredirect': {
            'Meta': {'object_name': 'LoginRedirect'},
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'redirect_to': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['django_intranet_stuff.Staff']"}),
            'staff': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'login_redirects'", 'to': "orm['django_intranet_stuff.Staff']"})
        },
        'ml.maillist': {
            'Meta': {'ordering': "('name',)", 'unique_together': "[('alias', 'parent')]", 'object_name': 'MailList', 'db_table': "'wakka_maillists'"},
            'alias': ('django.db.models.fields.CharField', [], {'max_length': '255', 'db_index': 'True'}),
            'archiving_type': ('django.db.models.fields.CharField', [], {'default': "'clean'", 'max_length': '7'}),
            'before_clean': ('django.db.models.fields.IntegerField', [], {'default': 'None', 'null': 'True', 'blank': 'True'}),
            'created_at': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now'}),
            'created_dt': ('django.db.models.fields.DateTimeField', [], {'null': 'True', 'db_index': 'True'}),
            'email': ('django.db.models.fields.EmailField', [], {'max_length': '255', 'null': 'True', 'db_index': 'True'}),
            'external_staff_can_read': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'fid': ('django.db.models.fields.BigIntegerField', [], {'null': 'True', 'blank': 'True'}),
            'fsuid': ('django.db.models.fields.BigIntegerField', [], {'null': 'True', 'blank': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'imap_users': ('django.db.models.fields.PositiveIntegerField', [], {'default': '0'}),
            'info': ('django.db.models.fields.TextField', [], {}),
            'info_en': ('django.db.models.fields.TextField', [], {'default': "''"}),
            'info_modified': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'is_archive': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'is_deleted': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'is_hidden': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'is_imap': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'is_internal': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'is_mandatory': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'is_manual': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'is_open': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'is_relevance_tracked': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'is_sms': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'is_sub': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'is_virtual': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'letter': ('django.db.models.fields.CharField', [], {'max_length': '1', 'db_index': 'True'}),
            'max_length': ('django.db.models.fields.PositiveIntegerField', [], {}),
            'modified_at': ('django.db.models.fields.DateTimeField', [], {'auto_now': 'True', 'blank': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '255', 'db_index': 'True'}),
            'parent': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'children'", 'null': 'True', 'to': "orm['ml.MailList']"}),
            'preferred_language': ('django.db.models.fields.CharField', [], {'default': "'ru'", 'max_length': '6', 'db_index': 'True'}),
            'readonly': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'relevance': ('django.db.models.fields.FloatField', [], {'default': '0.0', 'db_index': 'True'}),
            'sub_users': ('django.db.models.fields.PositiveIntegerField', [], {'default': '0'})
        },
        'ml.operationlog': {
            'Meta': {'ordering': "('-started',)", 'object_name': 'OperationLog'},
            'arguments': ('django.db.models.fields.TextField', [], {'default': "''"}),
            'comment': ('django.db.models.fields.TextField', [], {}),
            'comp_status': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '255'}),
            'finished': ('django.db.models.fields.DateTimeField', [], {'null': 'True', 'blank': 'True'}),
            'initiator': ('django.db.models.fields.CharField', [], {'max_length': '255', 'db_index': 'True'}),
            'list': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['ml.MailList']", 'null': 'True', 'blank': 'True'}),
            'messages': ('django.db.models.fields.TextField', [], {}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'parent': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'children'", 'null': 'True', 'to': "orm['ml.OperationLog']"}),
            'retry_parent': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['ml.OperationLog']", 'null': 'True', 'blank': 'True'}),
            'root': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'ifroot_descendants'", 'null': 'True', 'to': "orm['ml.OperationLog']"}),
            'started': ('django.db.models.fields.DateTimeField', [], {'db_index': 'True', 'null': 'True', 'blank': 'True'}),
            'status': ('django.db.models.fields.CharField', [], {'max_length': '100', 'db_index': 'True'}),
            'task_id': ('django.db.models.fields.CharField', [], {'max_length': '255', 'primary_key': 'True'}),
            'type': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'user': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['auth.User']", 'null': 'True', 'blank': 'True'})
        },
        'ml.owner': {
            'Meta': {'unique_together': "[('user', 'list')]", 'object_name': 'Owner', 'db_table': "'mailarchive_owner'"},
            'created': ('django.db.models.fields.DateTimeField', [], {'auto_now_add': 'True', 'blank': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'list': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['ml.MailList']"}),
            'user': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['auth.User']"})
        },
        'ml.pendingbackendoperation': {
            'Meta': {'ordering': "('created',)", 'object_name': 'PendingBackendOperation', 'db_table': "'mailarchive_pendingbackendoperation'"},
            'attempts': ('django.db.models.fields.PositiveSmallIntegerField', [], {'default': '0'}),
            'backend_type': ('django.db.models.fields.CharField', [], {'max_length': '32'}),
            'created': ('django.db.models.fields.DateTimeField', [], {'auto_now_add': 'True', 'blank': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'is_notified': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'is_succeed': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'last_failure_info': ('django.db.models.fields.CharField', [], {'max_length': '256', 'blank': 'True'}),
            'max_attempts': ('django.db.models.fields.PositiveSmallIntegerField', [], {'default': '4'}),
            'operation_args': ('django.db.models.fields.CharField', [], {'max_length': '256'}),
            'operation_type': ('django.db.models.fields.CharField', [], {'max_length': '32'})
        },
        'ml.pendingsubscribeoperation': {
            'Meta': {'ordering': "('created',)", 'object_name': 'PendingSubscribeOperation', 'db_table': "'mailarchive_pendingsubscribeoperation'", '_ormbases': ['ml.PendingBackendOperation']},
            'list': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'pending_subscriptions'", 'to': "orm['ml.MailList']"}),
            'pendingbackendoperation_ptr': ('django.db.models.fields.related.OneToOneField', [], {'to': "orm['ml.PendingBackendOperation']", 'unique': 'True', 'primary_key': 'True'}),
            'user': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'pending_subscriptions'", 'to': "orm['auth.User']"})
        },
        'ml.subscribers': {
            'Meta': {'object_name': 'Subscribers', 'db_table': "'wakka_subscribers'"},
            'autosubscription': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['ml.Autosubscription']", 'null': 'True', 'blank': 'True'}),
            'created_at': ('django.db.models.fields.DateTimeField', [], {'auto_now_add': 'True', 'db_index': 'True', 'blank': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'is_imap': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'is_sub': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'list': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['ml.MailList']"}),
            'stype': ('django.db.models.fields.CharField', [], {'max_length': '15', 'db_index': 'True'}),
            'user': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'subscriptions'", 'to': "orm['auth.User']"})
        },
        'ml.suidlookup': {
            'Meta': {'object_name': 'SuidLookup'},
            'login': ('django.db.models.fields.CharField', [], {'max_length': '50', 'db_index': 'True'}),
            'suid': ('django.db.models.fields.BigIntegerField', [], {'primary_key': 'True'})
        }
    }

    complete_apps = ['ml']