# -*- coding: utf-8 -*-

from django.conf import settings

from mlcore.emails import Notification


class PendingOperationsFailed(Notification):
    template_type = 'pending_operations_failed.html'

    def send(self):
        recipients = []
        sender = settings.SERVICE_EMAIL
        return super(PendingOperationsFailed, self).send(
            recipients,
            sender=sender)


class CreateRequestEmail(Notification):
    template_type = 'create_request.html'
    content = 'plain'

    def send(self, sender):
        recipients = [settings.MAIL_ADMINS_EMAIL]
        return super(CreateRequestEmail, self).send(recipients, sender=sender)


class FeedbackFormEmail(Notification):
    template_type = 'feedback_form.html'
    content = 'plain'


class SubscribedByFriendEmail(Notification):
    template_type = 'subscribed_by_friend.html'

    def send(self, recepients, sender=None, cc=None):
        super(SubscribedByFriendEmail, self).send(recepients, sender=sender, cc=cc)


class SubscribedAutomatically(Notification):
    template_type = 'subscribed_automatically.html'

    def send(self, recepients, sender=None, cc=None):
        super(SubscribedAutomatically, self).send(recepients, sender=sender, cc=cc)


class NewSubscribe(Notification):
    template_type = 'new_subscribe.html'
    content = 'html'

    def send(self, recepients, sender=None, cc=None):
        super(NewSubscribe, self).send(recepients, sender=sender, cc=cc)


class MailListCreated(Notification):
    template_type = 'maillist_created.html'
    content = 'html'

    def send(self, recepients, cc=None):
        sender = settings.SERVICE_EMAIL
        super(MailListCreated, self).send(recepients, sender=sender, cc=cc)


class YaMailSubscriptionProblem(Notification):
    template_type = 'metacorp_subscription_problem.html'
    content = 'html'


class YorkDuplicateFolderProblem(Notification):
    template_type = 'york_duplicate_folder.html'
    content = 'html'
