# coding: utf-8
from traceback import print_exc

from celery import Task


class OperationChoices(object):
    def __init__(self, *modules):
        self.modules = modules
        self._choices = None

    def get_choices(self):
        if not self.modules:
            from mlcore.tasks import low_level, operations
            self.modules = [low_level, operations]

        res = []
        for module in self.modules:
            for name in dir(module):
                item = getattr(module, name)
                if isinstance(item, Task) and item.__doc__:
                    docs = item.__doc__.splitlines()
                    doc = docs[0] if docs[0].strip() else docs[1].strip()
                    res.append((module.__name__ + '.' + name, doc))

        return res

    @property
    def choices(self):
        if self._choices:
            return self._choices
        else:
            self._choices = self.get_choices()
            return self._choices

    def __iter__(self):
        try:
            result = self.choices.__iter__()
        except Exception:
            # that sh.t can be broken, but in manage.py command you will not see original stacktrace :/
            print_exc()
            raise
        return result


OP_CHOICES_NAME = OperationChoices()


OP_CHOICES_TYPE = (
    ('low_level', u'Низкоуровневые'),
    ('operations', u'Высокоуровневые')
)
