# -*- coding: utf-8 -*-
from mlcore.ml.models import MailList
from django.db.models import Q
from datetime import datetime

def list_searcher(mlname):
    if not mlname:
        return []

    mlname = mlname.lower()
    ml_qs = MailList.objects.prefetch_related('owner_set')
    # если воспользовались автокомплитом или ввели точный адрес
    if '@' in mlname:
        mlname = mlname.rstrip('@')
        return ml_qs.filter(name__exact=mlname)

    # если ввели только одну букву, то показываем список рассылок, начинающихся с этой буквы
    if len(mlname) == 1:
        return ml_qs.filter(name__istartswith=mlname).order_by('relevance')

    # сначала показываем все рассылки, начинающиеся с части названия, а потом все остальные
    return ml_qs.filter(
         Q(name__exact=mlname) | Q(name__icontains=mlname) | Q(name__istartswith=mlname)).order_by('relevance')
