#-*- coding: utf-8 -*-

from django import template
from django.conf import settings

register = template.Library()


@register.inclusion_tag('b-lang-switcher.html', takes_context=True)
def b_lang_switcher(context, lego_version=None,  ):
    u'Вставляет лего-блок переключения языка локали'

    path_to_template = 'lego/b-lang-switcher.html'

    switch_url = getattr(settings, 'LANG_SWITCH_URL', '/?lang=')

    return {
        'template': path_to_template,
        'request': context['request'],
        'switch_url': switch_url,
    }    


@register.inclusion_tag('b-foot.html', takes_context=True)
def b_foot(context, about_url='', lego_version=None):
    u""" Вставляет стандартный интранет-футер с переключалкой языка """

    path_to_template = 'lego/b-foot.html'

    return {
        'template': path_to_template,
        'request': context['request'],
        'about_url': about_url,
    }    

