# -*- coding: utf-8 -*-
import logging

import requests
from django import template
from django.conf import settings
from django.utils.safestring import mark_safe, mark_for_escaping
from string import digits

from requests import RequestException

from mlcore.ml.models import Owner, MailList
from mlcore.permissions.models import ListPermission

import urllib

register = template.Library()

logger = logging.getLogger(__name__)


class URLopener(urllib.URLopener):
    version = 'ML (http://ml.yandex-team.ru/)'

urllib._urlopener = URLopener()


@register.inclusion_tag('ml/templatetags/requests_count.html', takes_context=True)
def requests_count(context):
    if not 'user' in context:
        return {}

    they_requests = ListPermission.objects.filter(approved=False).filter(
        list__in=Owner.objects.filter(user=context['user']).values_list('list', flat=True)
    )

    return {'they_requests_count': they_requests.count()}


@register.inclusion_tag('ml/templatetags/letters.html', takes_context=True)
def letters(context, maillist=None):
    letters = MailList.objects.values_list("letter", flat=True).distinct()
    a_int = ord("a")
    z_int = ord("z")
    i = a_int
    ze_letters = [{"letter": d, "empty": False, "text": d} for d in digits if d in letters]

    while True:
        letter = chr(i).upper()
        text = letter
        if letter == "I":
            text = "&nbsp;I&nbsp;"
        if letter in letters:
            ze_letters.append({"letter": letter, "empty": False, "text": text})
        else:
            ze_letters.append({"letter": letter, "empty": True, "text": text})
        i += 1
        if i > z_int:
            break

    return {
        'letters': ze_letters,
        'list': maillist,
        'freshness_edge': '',  # deprecated
    }


@register.filter(name='wiki_formatter')
def wiki_formatter(text):

    try:
        response = requests.post(settings.WIKI_FORMATTER_URL, data={'text': text.encode('utf-8')},
                                 timeout=settings.WIKI_FORMATTER_TIMEOUT)
        response.raise_for_status()
        return mark_safe(response.text)
    except RequestException:
        logger.exception('Wiki formatter failed')
        return text