# -*- coding: utf-8 -*-

from django.conf.urls import patterns, url, include

import views
import class_views


staff_node = class_views.StaffNode()

urlpatterns = patterns('',
    url(r'^main/index/$', views.index_maillists, name='index'),
    url(r'^main/gosmails/$', views.index_gosmaillists, name='gosmails'),
    url(r'^lists/([^\s\\/]+)/$', class_views.ShowList(), name='list'),
    url(r'^lists/([^\s\\/]+)/subscribe_friend/$', views.subscribe_friend, name="subscribe_friend"),
    url(r'^lists/([^\s\\/]+)/subscribe_maillist/$', views.subscribe_maillist, name="subscribe_maillist"),
    url(r'^lists/([^\s\\/]+)/csv_subscribers/$', class_views.ListSubscribersCVS(), name='csv_subs'),
    url(r'^lists/([^\s\\/]+)/subscribers/$', class_views.ListSubscribersHTML(), name='list_subs'),
    url(r'^lists/([^\s\\/]+)/permissions/$', views.change_permissions, name='change_permissions'),
    url(r'^lists/([^\s\\/]+)/unsubscribe/$', views.unsubscribe, name='unsubscribe'),
    # Ручка, которую дёргают из List-Unsubscribe (ML-1231)
    url(r'^lists/([^\s\\/]+)/unsubscribe-click$', views.unsubscribe_click, name='unsubscribe-click'),
    url(r'^lists/(?P<ml_name>[^\s\\/]+)/subscribe/(?P<stype>\w+)/$',
        views.change_subscription_type, name='subscribe'),
    url(r'^lists/(?P<ml_name>[^\s\\/]+)/subscribe/$',
        views.change_subscription_type, name='change_subtype'),
    url(r'^lists/([^\s\\/]+)/group_revoke/$',
        class_views.GroupRevoke(), name='group_revoke'),
    url(r'^lists/([^\s\\/]+)/discard_request/$',
        views.discard_subscription_request, name='discard_request'),

    url(r'^lists/(?P<ml_name>[^\s\\/]+)/delete-owner/(?P<owner_name>[0-9A-Za-z@\._\-]+)$',
        views.delete_owner, name='delete-owner'),
    url(r'^lists/(?P<ml_name>[^\s\\/]+)/del-maillist/$',
        views.mark_delete_ml, name='del-maillist'),
    url(r'^lists/(?P<ml_name>[^\s\\/]+)/info-del-maillist/$',
        views.info_delete_ml, name='info-del-maillist'),
    url(r'^lists/(?P<ml_name>[^\s\\/]+)/del-parent/$',
        views.delete_parent, name='del-parent'),

    url(r'^lists/(?P<ml_name>[^\s\\/]+)/edit-list-properties/$',
        class_views.EditListProperties(), name='edit-list-properties'),
    url(r'^lists/(?P<ml_name>[^\s\\/]+)/edit-other-list-properties/$',
        class_views.EditListOtherProperties(), name='edit-other-list-properties'),
    url(r'^lists/(?P<ml_name>[^\s\\/]+)/edit-owner-properties/$',
        class_views.EditOwnerProperties(), name='edit-owner-properties'),

    url(r'^lists/(?P<ml_name>[^\s\\/]+)/autoreply/$',
        class_views.AutoreplySettings(), name='autoreply'),
    url(r'^lists/(?P<ml_name>[^\s\\/]+)/autoreply/(?P<a_id>[0-9A-Za-z@\._\-]+)$',
        views.delete_autoreply, name='del-autoreply'),
    url(r'^lists/(?P<ml_name>[^\s\\/]+)/autoreply_change_order/(?P<main_id>[0-9A-Za-z@\._\-]+)$',
        views.set_priority_autoreply, name='change-order-autoreply'),
    url(r'^lists/(?P<ml_name>[^\s\\/]+)/autoreply_set_main/(?P<main_id>[0-9A-Za-z@\._\-]+)$',
        views.set_main_autoreply, name='set-main-autoreply'),
    url(r'^lists/(?P<ml_name>[^\s\\/]+)/(?P<rule_id>[0-9A-Za-z@\._\-]+)/(?P<enable>[0,1]+)/$',
        views.set_enabled_autoreply, name='set-enabled-autoreply'),
    url(r'^change_properties/([^\s\\/]+)/([0-9_]+)/$',
        views.change_priorities_autoreply, name='change-priorities-autoreply'),

    url(r'^lists/(?P<ml_name>[^\s\\/]+)/forward/$',
        class_views.ForwardSettings(), name='forward'),
    url(r'^lists/(?P<ml_name>[^\s\\/]+)/forward/(?P<forward_id>[0-9A-Za-z@\._\-]+)$',
        views.delete_forward, name='delete-forward'),

    url(r'^department/$', views.get_department_staff, name='department_staff'),
    url(r'^login/$', views.redirect_to_passport, name='login'),
    url(r'^feedback/$', views.feedback, name='feedback'),
    url(r'^request/$', class_views.CreateRequest(), name='create_request'),
    url(r'^staff/(?P<username>[-_.a-zA-Z0-9]+)/$', staff_node),
    url(r'^~(?P<username>[-_.a-zA-Z0-9]+)/?$', staff_node, name='staff'),
    url(r'^~$', views.staff_redirect),
    url(r'^~/search_maillist/$', views.search_maillist, name='search_maillist'),
    url(r'^~/requests/$', views.subscription_requests, name='requests'),
    url(r'^$', views.staff_redirect),

    url(r'^ping/$', views.ping),
    url(r'^retry_task/$', views.retry_task, name='retry_task'),
    url(r'^/lookup/$', views.subscribers_lookup),
)


